/**!
 * @author Elgato
 * @module elgato/streamdeck
 * @license MIT
 * @copyright Copyright (c) Corsair Memory Inc.
 */
'use strict';

/**
 * Custom keyword definitions.
 */
const keywordDefinitions = {
    /**
     * The `markdownDescription` keyword definition; used to define descriptions with markdown syntax.
     */
    markdownDescription: {
        /**
         * String that identifies the `markdownDescription` keyword.
         */
        keyword: "markdownDescription",
        /**
         * Schema type of the keyword.
         */
        schemaType: "string"
    },
    /**
     * The `errorMessage` keyword definition; used to define custom error messages.
     */
    errorMessage: {
        /**
         * String that identifies the `errorMessage` keyword.
         */
        keyword: "errorMessage",
        /**
         * Schema type of the keyword.
         */
        schemaType: "string"
    },
    /**
     * The `imageDimensions` keyword definition; used to validate dimensions of images.
     */
    imageDimensions: {
        /**
         * String that identifies the `imageDimensions` keyword.
         */
        keyword: "imageDimensions",
        /**
         * Schema type of the keyword.
         */
        schemaType: "array"
    },
    /**
     * The `filePath` keyword definition; used to validate strings that represent file paths.
     */
    filePath: {
        /**
         * String that identifies the `filePath` keyword.
         */
        keyword: "filePath",
        /**
         * Schema type of the keyword.
         */
        schemaType: ["boolean", "object"]
    }
};

exports.keywordDefinitions = keywordDefinitions;
