/**!
 * @author Elgato
 * @module elgato/streamdeck
 * @license MIT
 * @copyright Copyright (c) Corsair Memory Inc.
 */
/**
 * Custom keyword definitions.
 */
declare const keywordDefinitions: {
    /**
     * The `markdownDescription` keyword definition; used to define descriptions with markdown syntax.
     */
    markdownDescription: {
        /**
         * String that identifies the `markdownDescription` keyword.
         */
        keyword: string;
        /**
         * Schema type of the keyword.
         */
        schemaType: "string";
    };
    /**
     * The `errorMessage` keyword definition; used to define custom error messages.
     */
    errorMessage: {
        /**
         * String that identifies the `errorMessage` keyword.
         */
        keyword: string;
        /**
         * Schema type of the keyword.
         */
        schemaType: "string";
    };
    /**
     * The `imageDimensions` keyword definition; used to validate dimensions of images.
     */
    imageDimensions: {
        /**
         * String that identifies the `imageDimensions` keyword.
         */
        keyword: string;
        /**
         * Schema type of the keyword.
         */
        schemaType: "array";
    };
    /**
     * The `filePath` keyword definition; used to validate strings that represent file paths.
     */
    filePath: {
        /**
         * String that identifies the `filePath` keyword.
         */
        keyword: string;
        /**
         * Schema type of the keyword.
         */
        schemaType: ("boolean" | "object")[];
    };
};
/**
 * Options associated with the {@link keywordDefinitions.filePath} keyword.
 */
type FilePathOptions = true | {
    /**
     * Collection of valid file extensions.
     */
    extensions: string[];
    /**
     * Determines whether the extension must be present, or omitted, from the file path.
     */
    includeExtension: boolean;
};
/**
 * Options associated with the {@link keywordDefinitions.imageDimensions} keyword.
 */
type ImageDimensions = [width: number, height: number];

export { type FilePathOptions, type ImageDimensions, keywordDefinitions };
