/**!
 * @author Elgato
 * @module elgato/streamdeck
 * @license MIT
 * @copyright Copyright (c) Corsair Memory Inc.
 */
var $id$1 = "@elgato/schemas/streamdeck/plugins/layout@0.4.13";
var $schema$1 = "http://json-schema.org/draft-07/schema#";
var $ref$1 = "#/definitions/Layout";
var definitions$1 = {
	Layout: {
		type: "object",
		properties: {
			$schema: {
				type: "string",
				description: "JSON schema responsible for describing the manifest's data format and validation.",
				markdownDescription: "JSON schema responsible for describing the manifest's data format and validation."
			},
			id: {
				type: "string",
				description: "Unique identifier associated with the layout.",
				markdownDescription: "Unique identifier associated with the layout."
			},
			items: {
				type: "array",
				items: {
					type: "object",
					properties: {
						type: {
							"enum": [
								"bar",
								"gbar",
								"pixmap",
								"text"
							]
						}
					},
					required: [
						"type"
					],
					allOf: [
						{
							"if": {
								properties: {
									type: {
										type: "string",
										"const": "bar",
										description: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime.",
										markdownDescription: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime."
									}
								}
							},
							then: {
								$ref: "#/definitions/Bar"
							}
						},
						{
							"if": {
								properties: {
									type: {
										type: "string",
										"const": "gbar",
										description: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime.",
										markdownDescription: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime."
									}
								}
							},
							then: {
								$ref: "#/definitions/GBar"
							}
						},
						{
							"if": {
								properties: {
									type: {
										type: "string",
										"const": "pixmap",
										description: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime.",
										markdownDescription: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime."
									}
								}
							},
							then: {
								$ref: "#/definitions/Pixmap"
							}
						},
						{
							"if": {
								properties: {
									type: {
										type: "string",
										"const": "text",
										description: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime.",
										markdownDescription: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime."
									}
								}
							},
							then: {
								$ref: "#/definitions/Text"
							}
						}
					],
					description: "A layout item.",
					markdownDescription: "A layout item."
				},
				description: "Items within the layout.",
				markdownDescription: "Items within the layout."
			}
		},
		required: [
			"id",
			"items"
		],
		additionalProperties: false,
		description: "Defines the structure of a custom layout file.",
		markdownDescription: "Defines the structure of a custom layout file."
	},
	Bar: {
		type: "object",
		additionalProperties: false,
		properties: {
			bar_bg_c: {
				type: "string",
				description: "Bar background color represented as a named color, hexadecimal value, or gradient. Default is `darkGray`. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)",
				examples: [
					"darkGray"
				],
				markdownDescription: "Bar background color represented as a named color, hexadecimal value, or gradient. Default is `darkGray`. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)"
			},
			bar_border_c: {
				type: "string",
				description: "Border color represented as a named color, or hexadecimal value. Default is `white`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)",
				examples: [
					"white"
				],
				markdownDescription: "Border color represented as a named color, or hexadecimal value. Default is `white`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)"
			},
			bar_fill_c: {
				type: "string",
				description: "Fill color of the bar represented as a named color, hexadecimal value, or gradient. Default is `white`. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)",
				examples: [
					"white"
				],
				markdownDescription: "Fill color of the bar represented as a named color, hexadecimal value, or gradient. Default is `white`. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)"
			},
			border_w: {
				type: "number",
				description: "Width of the border around the bar, as a whole number. Default is `2`.",
				examples: [
					2
				],
				markdownDescription: "Width of the border around the bar, as a whole number. Default is `2`."
			},
			range: {
				$ref: "#/definitions/Range",
				description: "Defines the range of the value the bar represents, e.g. 0-20, 0-100, etc.",
				markdownDescription: "Defines the range of the value the bar represents, e.g. 0-20, 0-100, etc."
			},
			subtype: {
				type: "number",
				"enum": [
					0,
					1,
					2,
					3,
					4
				],
				description: "Sub-type used to determine the type of bar to render. Default is  {@link  BarSubType.Groove }  (4).\n\n**Options**\n- Rectangle (0)\n- DoubleRectangle (1)\n- Trapezoid (2)\n- DoubleTrapezoid (3)\n- Groove (4)",
				markdownDescription: "Sub-type used to determine the type of bar to render. Default is  {@link  BarSubType.Groove }  (4).\n\n**Options**\n- Rectangle (0)\n- DoubleRectangle (1)\n- Trapezoid (2)\n- DoubleTrapezoid (3)\n- Groove (4)"
			},
			value: {
				type: "number",
				description: "Value used to determine how much of the bar is filled. Correlates with the item's `range` if specified in the layout's JSON definition; default range is `0..100`.",
				markdownDescription: "Value used to determine how much of the bar is filled. Correlates with the item's `range` if specified in the layout's JSON definition; default range is `0..100`."
			},
			background: {
				type: "string",
				description: "Background color represented as a named color, hexadecimal value, or gradient. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)",
				markdownDescription: "Background color represented as a named color, hexadecimal value, or gradient. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)"
			},
			enabled: {
				type: "boolean",
				description: "Determines whether the item is enabled (i.e. visible); default is `true`.",
				markdownDescription: "Determines whether the item is enabled (i.e. visible); default is `true`."
			},
			key: {
				type: "string",
				description: "Unique name used to identify the layout item. When calling `setFeedback` this value should be used as the key as part of the object that represents the feedback.\n\nNote: The `key` of the layout item cannot be changed at runtime.",
				pattern: "^[A-Za-z0-9\\-_]+$",
				errorMessage: "String must only contain alphanumeric characters (A-z, 0-9), hyphens (-), and underscores (_)",
				markdownDescription: "Unique name used to identify the layout item. When calling `setFeedback` this value should be used as the key as part of the object that represents the feedback.\n\nNote: The `key` of the layout item cannot be changed at runtime."
			},
			opacity: {
				type: "number",
				"enum": [
					0,
					0.1,
					0.2,
					0.3,
					0.4,
					0.5,
					0.6,
					0.7,
					0.8,
					0.9,
					1
				],
				description: "Defines the opacity of the item being shown based on a single-decimal value ranging from `0..1`, e.g. `0.1`, `0.2`, etc. with `0` being invisible and `1` being fully visible. Default is `1`.",
				markdownDescription: "Defines the opacity of the item being shown based on a single-decimal value ranging from `0..1`, e.g. `0.1`, `0.2`, etc. with `0` being invisible and `1` being fully visible. Default is `1`."
			},
			rect: {
				type: "array",
				minItems: 4,
				items: [
					{
						type: "number",
						description: "X coordinate of the rectangle.",
						minimum: 0,
						maximum: 200,
						title: "x",
						markdownDescription: "X coordinate of the rectangle."
					},
					{
						type: "number",
						description: "Y coordinate of the rectangle.",
						minimum: 0,
						maximum: 100,
						title: "y",
						markdownDescription: "Y coordinate of the rectangle."
					},
					{
						type: "number",
						description: "Width of the rectangle.",
						minimum: 0,
						maximum: 200,
						title: "width",
						markdownDescription: "Width of the rectangle."
					},
					{
						type: "number",
						description: "Height of the rectangle.",
						minimum: 0,
						maximum: 100,
						title: "height",
						markdownDescription: "Height of the rectangle."
					}
				],
				maxItems: 4,
				description: "Array defining the items coordinates in the format `[x, y, width, height]`; coordinates must be within canvas size of 200 x 100, e.g. [0, 0, 200, 100]. Items with the same `zOrder` must **not** have an overlapping `rect`.\n\nNote: The `rect` of the layout item cannot be changed at runtime.",
				markdownDescription: "Array defining the items coordinates in the format `[x, y, width, height]`; coordinates must be within canvas size of 200 x 100, e.g. [0, 0, 200, 100]. Items with the same `zOrder` must **not** have an overlapping `rect`.\n\nNote: The `rect` of the layout item cannot be changed at runtime."
			},
			type: {
				type: "string",
				"const": "bar",
				description: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime.",
				markdownDescription: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime."
			},
			zOrder: {
				type: "number",
				description: "Z-order of the item, used to layer items within a layout; must be between 0-700. Items with the same `zOrder` must **not** have an overlapping `rect`. Default is `0`.",
				minimum: 0,
				maximum: 700,
				markdownDescription: "Z-order of the item, used to layer items within a layout; must be between 0-700. Items with the same `zOrder` must **not** have an overlapping `rect`. Default is `0`."
			}
		},
		required: [
			"key",
			"rect",
			"type",
			"value"
		],
		description: "Bar layout item used to render a horizontal bar with a filler, e.g. a progress bar. The amount to fill the bar by can be specified by setting the `value`.",
		markdownDescription: "Bar layout item used to render a horizontal bar with a filler, e.g. a progress bar. The amount to fill the bar by can be specified by setting the `value`."
	},
	Range: {
		type: "object",
		properties: {
			min: {
				type: "number",
				description: "Minimum value of the bar.",
				markdownDescription: "Minimum value of the bar."
			},
			max: {
				type: "number",
				description: "Maximum value of the bar.",
				markdownDescription: "Maximum value of the bar."
			}
		},
		required: [
			"min",
			"max"
		],
		additionalProperties: false,
		description: "Defines the range of the value the bar represents, e.g. 0-20, 0-100, etc.",
		markdownDescription: "Defines the range of the value the bar represents, e.g. 0-20, 0-100, etc."
	},
	GBar: {
		type: "object",
		additionalProperties: false,
		properties: {
			bar_h: {
				type: "number",
				description: "Height of the bar's indicator. Default is `10`.",
				examples: [
					10
				],
				markdownDescription: "Height of the bar's indicator. Default is `10`."
			},
			bar_bg_c: {
				type: "string",
				description: "Bar background color represented as a named color, hexadecimal value, or gradient. Default is `darkGray`. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)",
				examples: [
					"darkGray"
				],
				markdownDescription: "Bar background color represented as a named color, hexadecimal value, or gradient. Default is `darkGray`. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)"
			},
			bar_border_c: {
				type: "string",
				description: "Border color represented as a named color, or hexadecimal value. Default is `white`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)",
				examples: [
					"white"
				],
				markdownDescription: "Border color represented as a named color, or hexadecimal value. Default is `white`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)"
			},
			bar_fill_c: {
				type: "string",
				description: "Fill color of the bar represented as a named color, hexadecimal value, or gradient. Default is `white`. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)",
				examples: [
					"white"
				],
				markdownDescription: "Fill color of the bar represented as a named color, hexadecimal value, or gradient. Default is `white`. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)"
			},
			border_w: {
				type: "number",
				description: "Width of the border around the bar, as a whole number. Default is `2`.",
				examples: [
					2
				],
				markdownDescription: "Width of the border around the bar, as a whole number. Default is `2`."
			},
			range: {
				$ref: "#/definitions/Range",
				description: "Defines the range of the value the bar represents, e.g. 0-20, 0-100, etc.",
				markdownDescription: "Defines the range of the value the bar represents, e.g. 0-20, 0-100, etc."
			},
			subtype: {
				type: "number",
				"enum": [
					0,
					1,
					2,
					3,
					4
				],
				description: "Sub-type used to determine the type of bar to render. Default is  {@link  BarSubType.Groove }  (4).\n\n**Options**\n- Rectangle (0)\n- DoubleRectangle (1)\n- Trapezoid (2)\n- DoubleTrapezoid (3)\n- Groove (4)",
				markdownDescription: "Sub-type used to determine the type of bar to render. Default is  {@link  BarSubType.Groove }  (4).\n\n**Options**\n- Rectangle (0)\n- DoubleRectangle (1)\n- Trapezoid (2)\n- DoubleTrapezoid (3)\n- Groove (4)"
			},
			value: {
				type: "number",
				description: "Value used to determine how much of the bar is filled. Correlates with the item's `range` if specified in the layout's JSON definition; default range is `0..100`.",
				markdownDescription: "Value used to determine how much of the bar is filled. Correlates with the item's `range` if specified in the layout's JSON definition; default range is `0..100`."
			},
			background: {
				type: "string",
				description: "Background color represented as a named color, hexadecimal value, or gradient. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)",
				markdownDescription: "Background color represented as a named color, hexadecimal value, or gradient. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)"
			},
			enabled: {
				type: "boolean",
				description: "Determines whether the item is enabled (i.e. visible); default is `true`.",
				markdownDescription: "Determines whether the item is enabled (i.e. visible); default is `true`."
			},
			key: {
				type: "string",
				description: "Unique name used to identify the layout item. When calling `setFeedback` this value should be used as the key as part of the object that represents the feedback.\n\nNote: The `key` of the layout item cannot be changed at runtime.",
				pattern: "^[A-Za-z0-9\\-_]+$",
				errorMessage: "String must only contain alphanumeric characters (A-z, 0-9), hyphens (-), and underscores (_)",
				markdownDescription: "Unique name used to identify the layout item. When calling `setFeedback` this value should be used as the key as part of the object that represents the feedback.\n\nNote: The `key` of the layout item cannot be changed at runtime."
			},
			opacity: {
				type: "number",
				"enum": [
					0,
					0.1,
					0.2,
					0.3,
					0.4,
					0.5,
					0.6,
					0.7,
					0.8,
					0.9,
					1
				],
				description: "Defines the opacity of the item being shown based on a single-decimal value ranging from `0..1`, e.g. `0.1`, `0.2`, etc. with `0` being invisible and `1` being fully visible. Default is `1`.",
				markdownDescription: "Defines the opacity of the item being shown based on a single-decimal value ranging from `0..1`, e.g. `0.1`, `0.2`, etc. with `0` being invisible and `1` being fully visible. Default is `1`."
			},
			rect: {
				type: "array",
				minItems: 4,
				items: [
					{
						type: "number",
						description: "X coordinate of the rectangle.",
						minimum: 0,
						maximum: 200,
						title: "x",
						markdownDescription: "X coordinate of the rectangle."
					},
					{
						type: "number",
						description: "Y coordinate of the rectangle.",
						minimum: 0,
						maximum: 100,
						title: "y",
						markdownDescription: "Y coordinate of the rectangle."
					},
					{
						type: "number",
						description: "Width of the rectangle.",
						minimum: 0,
						maximum: 200,
						title: "width",
						markdownDescription: "Width of the rectangle."
					},
					{
						type: "number",
						description: "Height of the rectangle.",
						minimum: 0,
						maximum: 100,
						title: "height",
						markdownDescription: "Height of the rectangle."
					}
				],
				maxItems: 4,
				description: "Array defining the items coordinates in the format `[x, y, width, height]`; coordinates must be within canvas size of 200 x 100, e.g. [0, 0, 200, 100]. Items with the same `zOrder` must **not** have an overlapping `rect`.\n\nNote: The `rect` of the layout item cannot be changed at runtime.",
				markdownDescription: "Array defining the items coordinates in the format `[x, y, width, height]`; coordinates must be within canvas size of 200 x 100, e.g. [0, 0, 200, 100]. Items with the same `zOrder` must **not** have an overlapping `rect`.\n\nNote: The `rect` of the layout item cannot be changed at runtime."
			},
			type: {
				type: "string",
				"const": "gbar",
				description: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime.",
				markdownDescription: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime."
			},
			zOrder: {
				type: "number",
				description: "Z-order of the item, used to layer items within a layout; must be between 0-700. Items with the same `zOrder` must **not** have an overlapping `rect`. Default is `0`.",
				minimum: 0,
				maximum: 700,
				markdownDescription: "Z-order of the item, used to layer items within a layout; must be between 0-700. Items with the same `zOrder` must **not** have an overlapping `rect`. Default is `0`."
			}
		},
		required: [
			"key",
			"rect",
			"type",
			"value"
		],
		description: "Bar layout item used to render a horizontal bar with an indicator represented as a triangle beneath the bar. The location of the indicator can be specified by setting the `value`.",
		markdownDescription: "Bar layout item used to render a horizontal bar with an indicator represented as a triangle beneath the bar. The location of the indicator can be specified by setting the `value`."
	},
	Pixmap: {
		type: "object",
		additionalProperties: false,
		properties: {
			value: {
				type: "string",
				description: "Image to render; this can be either a path to a local file within the plugin's folder, a base64 encoded `string` with the mime type declared (e.g. PNG, JPEG, etc.), or an SVG `string`.\n\n**Examples:**\n- \"imgs/Logo.png\"\n- \"data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSI1MHB0IiBoZWlnaHQ9…\"",
				markdownDescription: "Image to render; this can be either a path to a local file within the plugin's folder, a base64 encoded `string` with the mime type declared (e.g. PNG, JPEG, etc.), or an SVG `string`.\n\n**Examples:**\n- \"imgs/Logo.png\"\n- \"data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSI1MHB0IiBoZWlnaHQ9…\""
			},
			background: {
				type: "string",
				description: "Background color represented as a named color, hexadecimal value, or gradient. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)",
				markdownDescription: "Background color represented as a named color, hexadecimal value, or gradient. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)"
			},
			enabled: {
				type: "boolean",
				description: "Determines whether the item is enabled (i.e. visible); default is `true`.",
				markdownDescription: "Determines whether the item is enabled (i.e. visible); default is `true`."
			},
			key: {
				type: "string",
				description: "Unique name used to identify the layout item. When calling `setFeedback` this value should be used as the key as part of the object that represents the feedback.\n\nNote: The `key` of the layout item cannot be changed at runtime.",
				pattern: "^[A-Za-z0-9\\-_]+$",
				errorMessage: "String must only contain alphanumeric characters (A-z, 0-9), hyphens (-), and underscores (_)",
				markdownDescription: "Unique name used to identify the layout item. When calling `setFeedback` this value should be used as the key as part of the object that represents the feedback.\n\nNote: The `key` of the layout item cannot be changed at runtime."
			},
			opacity: {
				type: "number",
				"enum": [
					0,
					0.1,
					0.2,
					0.3,
					0.4,
					0.5,
					0.6,
					0.7,
					0.8,
					0.9,
					1
				],
				description: "Defines the opacity of the item being shown based on a single-decimal value ranging from `0..1`, e.g. `0.1`, `0.2`, etc. with `0` being invisible and `1` being fully visible. Default is `1`.",
				markdownDescription: "Defines the opacity of the item being shown based on a single-decimal value ranging from `0..1`, e.g. `0.1`, `0.2`, etc. with `0` being invisible and `1` being fully visible. Default is `1`."
			},
			rect: {
				type: "array",
				minItems: 4,
				items: [
					{
						type: "number",
						description: "X coordinate of the rectangle.",
						minimum: 0,
						maximum: 200,
						title: "x",
						markdownDescription: "X coordinate of the rectangle."
					},
					{
						type: "number",
						description: "Y coordinate of the rectangle.",
						minimum: 0,
						maximum: 100,
						title: "y",
						markdownDescription: "Y coordinate of the rectangle."
					},
					{
						type: "number",
						description: "Width of the rectangle.",
						minimum: 0,
						maximum: 200,
						title: "width",
						markdownDescription: "Width of the rectangle."
					},
					{
						type: "number",
						description: "Height of the rectangle.",
						minimum: 0,
						maximum: 100,
						title: "height",
						markdownDescription: "Height of the rectangle."
					}
				],
				maxItems: 4,
				description: "Array defining the items coordinates in the format `[x, y, width, height]`; coordinates must be within canvas size of 200 x 100, e.g. [0, 0, 200, 100]. Items with the same `zOrder` must **not** have an overlapping `rect`.\n\nNote: The `rect` of the layout item cannot be changed at runtime.",
				markdownDescription: "Array defining the items coordinates in the format `[x, y, width, height]`; coordinates must be within canvas size of 200 x 100, e.g. [0, 0, 200, 100]. Items with the same `zOrder` must **not** have an overlapping `rect`.\n\nNote: The `rect` of the layout item cannot be changed at runtime."
			},
			type: {
				type: "string",
				"const": "pixmap",
				description: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime.",
				markdownDescription: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime."
			},
			zOrder: {
				type: "number",
				description: "Z-order of the item, used to layer items within a layout; must be between 0-700. Items with the same `zOrder` must **not** have an overlapping `rect`. Default is `0`.",
				minimum: 0,
				maximum: 700,
				markdownDescription: "Z-order of the item, used to layer items within a layout; must be between 0-700. Items with the same `zOrder` must **not** have an overlapping `rect`. Default is `0`."
			}
		},
		required: [
			"key",
			"rect",
			"type"
		],
		description: "Image layout item used to render an image sourced from either a local file located under the plugin's folder, or base64 encoded `string`. The `value` defines the image.",
		markdownDescription: "Image layout item used to render an image sourced from either a local file located under the plugin's folder, or base64 encoded `string`. The `value` defines the image."
	},
	Text: {
		type: "object",
		additionalProperties: false,
		properties: {
			alignment: {
				type: "string",
				"enum": [
					"center",
					"left",
					"right"
				],
				description: "Alignment of the text. Default is `\"center\"`. **Note**, when the `key` of this layout item is set to `\"title\"` within the layout's JSON definition, these values will be ignored in favour of the user's preferred title settings, as set in property inspector.",
				markdownDescription: "Alignment of the text. Default is `\"center\"`. **Note**, when the `key` of this layout item is set to `\"title\"` within the layout's JSON definition, these values will be ignored in favour of the user's preferred title settings, as set in property inspector."
			},
			color: {
				type: "string",
				description: "Color of the font represented as a named color, or hexadecimal value. Default is `white`. **Note**, when the `key` of this layout item is set to `\"title\"` within the layout's JSON definition, these values will be ignored in favour of the user's preferred title settings, as set in property inspector.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)",
				markdownDescription: "Color of the font represented as a named color, or hexadecimal value. Default is `white`. **Note**, when the `key` of this layout item is set to `\"title\"` within the layout's JSON definition, these values will be ignored in favour of the user's preferred title settings, as set in property inspector.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)"
			},
			font: {
				type: "object",
				properties: {
					size: {
						type: "number",
						description: "Size of the font, in pixels, represented as a whole number.\n\n**Note**, when the `key` of this layout item is set to `\"title\"` within the layout's JSON definition, this value will be ignored in favour of the user's preferred title settings, as set in property inspector.",
						markdownDescription: "Size of the font, in pixels, represented as a whole number.\n\n**Note**, when the `key` of this layout item is set to `\"title\"` within the layout's JSON definition, this value will be ignored in favour of the user's preferred title settings, as set in property inspector."
					},
					weight: {
						type: "number",
						description: "Weight of the font; value must be a whole `number` in the range of `100..1000`. **Note**, when the `key` of this layout item is set to `\"title\"` within the layout's JSON definition, this value will be ignored in favour of the user's preferred title settings, as set in property inspector.",
						minimum: 100,
						maximum: 1000,
						markdownDescription: "Weight of the font; value must be a whole `number` in the range of `100..1000`. **Note**, when the `key` of this layout item is set to `\"title\"` within the layout's JSON definition, this value will be ignored in favour of the user's preferred title settings, as set in property inspector."
					}
				},
				additionalProperties: false,
				description: "Defines how the font should be rendered. **Note**, when the `key` of this layout item is set to `\"title\"` within the layout's JSON definition, these values will be ignored in favour of the user's preferred title settings, as set in property inspector.",
				markdownDescription: "Defines how the font should be rendered. **Note**, when the `key` of this layout item is set to `\"title\"` within the layout's JSON definition, these values will be ignored in favour of the user's preferred title settings, as set in property inspector."
			},
			"text-overflow": {
				type: "string",
				"enum": [
					"clip",
					"ellipsis",
					"fade"
				],
				description: "Defines how overflowing text should be rendered on the layout.\n- clip, truncates the text at the boundary of the element (default).\n- ellipsis, truncates the text prior to the boundary of the element, and adds an ellipsis (…) to the end.\n- fade, applies a fade-gradient over the end of the text.",
				"default": "ellipsis",
				markdownDescription: "Defines how overflowing text should be rendered on the layout.\n- clip, truncates the text at the boundary of the element (default).\n- ellipsis, truncates the text prior to the boundary of the element, and adds an ellipsis (…) to the end.\n- fade, applies a fade-gradient over the end of the text."
			},
			value: {
				type: "string",
				description: "Text to be displayed.",
				markdownDescription: "Text to be displayed."
			},
			background: {
				type: "string",
				description: "Background color represented as a named color, hexadecimal value, or gradient. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)",
				markdownDescription: "Background color represented as a named color, hexadecimal value, or gradient. Gradients can be defined by specifying multiple color-stops separated by commas, in the following format `[{offset}:{color}[,]]`.\n\n**Examples:**\n- \"pink\"\n- \"#204cfe\" (Elgato blue)\n- \"0:#ff0000,0.5:yellow,1:#00ff00\" (Gradient)"
			},
			enabled: {
				type: "boolean",
				description: "Determines whether the item is enabled (i.e. visible); default is `true`.",
				markdownDescription: "Determines whether the item is enabled (i.e. visible); default is `true`."
			},
			key: {
				type: "string",
				description: "Unique name used to identify the layout item. When calling `setFeedback` this value should be used as the key as part of the object that represents the feedback.\n\nNote: The `key` of the layout item cannot be changed at runtime.",
				pattern: "^[A-Za-z0-9\\-_]+$",
				errorMessage: "String must only contain alphanumeric characters (A-z, 0-9), hyphens (-), and underscores (_)",
				markdownDescription: "Unique name used to identify the layout item. When calling `setFeedback` this value should be used as the key as part of the object that represents the feedback.\n\nNote: The `key` of the layout item cannot be changed at runtime."
			},
			opacity: {
				type: "number",
				"enum": [
					0,
					0.1,
					0.2,
					0.3,
					0.4,
					0.5,
					0.6,
					0.7,
					0.8,
					0.9,
					1
				],
				description: "Defines the opacity of the item being shown based on a single-decimal value ranging from `0..1`, e.g. `0.1`, `0.2`, etc. with `0` being invisible and `1` being fully visible. Default is `1`.",
				markdownDescription: "Defines the opacity of the item being shown based on a single-decimal value ranging from `0..1`, e.g. `0.1`, `0.2`, etc. with `0` being invisible and `1` being fully visible. Default is `1`."
			},
			rect: {
				type: "array",
				minItems: 4,
				items: [
					{
						type: "number",
						description: "X coordinate of the rectangle.",
						minimum: 0,
						maximum: 200,
						title: "x",
						markdownDescription: "X coordinate of the rectangle."
					},
					{
						type: "number",
						description: "Y coordinate of the rectangle.",
						minimum: 0,
						maximum: 100,
						title: "y",
						markdownDescription: "Y coordinate of the rectangle."
					},
					{
						type: "number",
						description: "Width of the rectangle.",
						minimum: 0,
						maximum: 200,
						title: "width",
						markdownDescription: "Width of the rectangle."
					},
					{
						type: "number",
						description: "Height of the rectangle.",
						minimum: 0,
						maximum: 100,
						title: "height",
						markdownDescription: "Height of the rectangle."
					}
				],
				maxItems: 4,
				description: "Array defining the items coordinates in the format `[x, y, width, height]`; coordinates must be within canvas size of 200 x 100, e.g. [0, 0, 200, 100]. Items with the same `zOrder` must **not** have an overlapping `rect`.\n\nNote: The `rect` of the layout item cannot be changed at runtime.",
				markdownDescription: "Array defining the items coordinates in the format `[x, y, width, height]`; coordinates must be within canvas size of 200 x 100, e.g. [0, 0, 200, 100]. Items with the same `zOrder` must **not** have an overlapping `rect`.\n\nNote: The `rect` of the layout item cannot be changed at runtime."
			},
			type: {
				type: "string",
				"const": "text",
				description: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime.",
				markdownDescription: "Type of layout item this instance represents, e.g. \"pixmap\", \"bar\", etc.\n\nNote: The `type` of the layout item cannot be changed at runtime."
			},
			zOrder: {
				type: "number",
				description: "Z-order of the item, used to layer items within a layout; must be between 0-700. Items with the same `zOrder` must **not** have an overlapping `rect`. Default is `0`.",
				minimum: 0,
				maximum: 700,
				markdownDescription: "Z-order of the item, used to layer items within a layout; must be between 0-700. Items with the same `zOrder` must **not** have an overlapping `rect`. Default is `0`."
			}
		},
		required: [
			"key",
			"rect",
			"type"
		],
		description: "Text layout item used to render text within a layout. **Note**, when adding a text item to the layout's JSON definition, setting the `key` to the `\"title\"` keyword will enable the user to specify the font's settings via the property inspector, and will cause `setTitle` to update this item.",
		markdownDescription: "Text layout item used to render text within a layout. **Note**, when adding a text item to the layout's JSON definition, setting the `key` to the `\"title\"` keyword will enable the user to specify the font's settings via the property inspector, and will cause `setTitle` to update this item."
	}
};
var layout = {
	$id: $id$1,
	$schema: $schema$1,
	$ref: $ref$1,
	definitions: definitions$1
};

var $id = "@elgato/schemas/streamdeck/plugins/manifest@0.4.13";
var $schema = "http://json-schema.org/draft-07/schema#";
var $ref = "#/definitions/Manifest";
var definitions = {
	Manifest: {
		description: "Defines the plugin and available actions, and all information associated with them, including the plugin's entry point, all iconography, action default behavior, etc.",
		markdownDescription: "Defines the plugin and available actions, and all information associated with them, including the plugin's entry point, all iconography, action default behavior, etc.",
		allOf: [
			{
				"if": {
					type: "object",
					properties: {
						Software: {
							type: "object",
							description: "Determines the Stream Deck software requirements for this plugin.",
							properties: {
								MinimumVersion: {
									type: "string",
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									"const": "6.4"
								}
							},
							required: [
								"MinimumVersion"
							]
						}
					},
					required: [
						"Software"
					]
				},
				then: {
					type: "object",
					additionalProperties: false,
					properties: {
						$schema: {
							type: "string",
							description: "JSON schema responsible for describing the manifest's data format and validation.",
							markdownDescription: "JSON schema responsible for describing the manifest's data format and validation."
						},
						Software: {
							type: "object",
							properties: {
								MinimumVersion: {
									type: "string",
									"const": "6.4",
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									markdownDescription: "Minimum version of the Stream Deck application required for this plugin to run."
								}
							},
							required: [
								"MinimumVersion"
							],
							additionalProperties: false,
							description: "Determines the Stream Deck software requirements for this plugin.",
							markdownDescription: "Determines the Stream Deck software requirements for this plugin."
						},
						ApplicationsToMonitor: {
							$ref: "#/definitions/ApplicationMonitoring",
							description: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`",
							markdownDescription: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`"
						},
						Author: {
							type: "string",
							description: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\".",
							markdownDescription: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\"."
						},
						Category: {
							type: "string",
							description: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group.",
							markdownDescription: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group."
						},
						CategoryIcon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							filePath: {
								extensions: [
									".svg",
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								28,
								28
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
						},
						CodePath: {
							type: "string",
							description: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathMac: {
							type: "string",
							description: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathWin: {
							type: "string",
							description: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						DefaultWindowSize: {
							type: "array",
							items: {
								type: "number"
							},
							minItems: 2,
							maxItems: 2,
							description: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`.",
							examples: [
								[
									500,
									650
								]
							],
							markdownDescription: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`."
						},
						Description: {
							type: "string",
							description: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace.",
							markdownDescription: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace."
						},
						Icon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							filePath: {
								extensions: [
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								256,
								256
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .png file in the plugin directory, with the file extension omitted."
						},
						Name: {
							type: "string",
							description: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc.",
							markdownDescription: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc."
						},
						OS: {
							type: "array",
							items: {
								$ref: "#/definitions/OS"
							},
							minItems: 1,
							maxItems: 2,
							description: "Collection of operating systems, and their minimum required versions, that the plugin supports.",
							markdownDescription: "Collection of operating systems, and their minimum required versions, that the plugin supports."
						},
						PropertyInspectorPath: {
							type: "string",
							description: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							filePath: {
								extensions: [
									".htm",
									".html"
								],
								includeExtension: true
							},
							markdownDescription: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
							errorMessage: "String must reference .htm, or .html file in the plugin directory."
						},
						URL: {
							type: "string",
							description: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com",
							markdownDescription: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com"
						},
						UUID: {
							type: "string",
							description: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch",
							pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
							errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
							markdownDescription: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch"
						},
						Version: {
							type: "string",
							description: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`.",
							examples: [
								"1.0.0.0"
							],
							pattern: "^(0|[1-9]\\d*)(\\.(0|[1-9]\\d*)){3}$",
							errorMessage: "String must use format {major}.{minor}.{patch}.{build}",
							markdownDescription: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`."
						},
						Nodejs: {
							type: "object",
							additionalProperties: false,
							properties: {
								Version: {
									type: "string",
									"const": "20",
									description: "Version of Node.js to use.",
									markdownDescription: "Version of Node.js to use."
								},
								Debug: {
									type: "string",
									description: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`.",
									examples: [
										"enabled",
										"break"
									],
									markdownDescription: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`."
								},
								GenerateProfilerOutput: {
									type: "boolean",
									description: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling).",
									markdownDescription: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling)."
								}
							},
							required: [
								"Version"
							],
							description: "Configuration options for Node.js based plugins.",
							markdownDescription: "Configuration options for Node.js based plugins."
						},
						SDKVersion: {
							type: "number",
							"const": 2,
							description: "Preferred SDK version; this should _currently_ always be 2.",
							markdownDescription: "Preferred SDK version; this should _currently_ always be 2."
						},
						Actions: {
							type: "array",
							items: {
								type: "object",
								properties: {
									Controllers: {
										type: "array",
										items: {
											$ref: "#/definitions/Controller"
										},
										minItems: 1,
										maxItems: 2,
										description: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +.",
										uniqueItems: true,
										markdownDescription: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +."
									},
									DisableAutomaticStates: {
										type: "boolean",
										description: "Determines whether the state of the action should automatically toggle when the user presses the action; only applies to actions that have more than one state defined. Default is `false`.",
										examples: [
											false
										],
										markdownDescription: "Determines whether the state of the action should automatically toggle when the user presses the action; only applies to actions that have more than one state defined. Default is `false`."
									},
									DisableCaching: {
										type: "boolean",
										description: "Determines whether Stream Deck should cache images associated with the plugin, and its actions. Default is `false`.",
										examples: [
											false
										],
										markdownDescription: "Determines whether Stream Deck should cache images associated with the plugin, and its actions. Default is `false`."
									},
									Encoder: {
										$ref: "#/definitions/Encoder",
										description: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen).",
										markdownDescription: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen)."
									},
									Icon: {
										type: "string",
										description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action in the Stream Deck application's action list.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 20 × 20 px and 40 × 40 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples:**\n- assets/counter\n- imgs/actions/mute",
										filePath: {
											extensions: [
												".svg",
												".png"
											],
											includeExtension: false
										},
										imageDimensions: [
											20,
											20
										],
										markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action in the Stream Deck application's action list.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 20 × 20 px and 40 × 40 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples:**\n- assets/counter\n- imgs/actions/mute",
										pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
										errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
									},
									Name: {
										type: "string",
										description: "Name of the action; this is displayed to the user in the actions list, and is used throughout the Stream Deck application to visually identify the action.",
										markdownDescription: "Name of the action; this is displayed to the user in the actions list, and is used throughout the Stream Deck application to visually identify the action."
									},
									PropertyInspectorPath: {
										type: "string",
										description: "Optional path to the HTML file that represents the property inspector for this action; this is displayed to the user in the Stream Deck application when they add the action, allowing them to configure the action's settings. When `undefined`, the manifest's top-level `PropertyInspectorPath` is used, otherwise none.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n**Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html",
										filePath: {
											extensions: [
												".htm",
												".html"
											],
											includeExtension: true
										},
										markdownDescription: "Optional path to the HTML file that represents the property inspector for this action; this is displayed to the user in the Stream Deck application when they add the action, allowing them to configure the action's settings. When `undefined`, the manifest's top-level `PropertyInspectorPath` is used, otherwise none.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n**Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html",
										pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
										errorMessage: "String must reference .htm, or .html file in the plugin directory."
									},
									States: {
										type: "array",
										items: {
											$ref: "#/definitions/State"
										},
										description: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`.",
										minItems: 1,
										markdownDescription: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`."
									},
									SupportedInMultiActions: {
										type: "boolean",
										description: "Determines whether the action is available to users when they are creating multi-actions. Default is `true`.",
										markdownDescription: "Determines whether the action is available to users when they are creating multi-actions. Default is `true`."
									},
									Tooltip: {
										type: "string",
										description: "Tooltip shown to the user when they hover over the action within the actions list in the Stream Deck application.",
										markdownDescription: "Tooltip shown to the user when they hover over the action within the actions list in the Stream Deck application."
									},
									UUID: {
										type: "string",
										description: "Unique identifier of the action, represented in reverse-DNS format. This value is supplied by Stream Deck when events are emitted that relate to the action enabling you to identify the source of the event.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\nNote: `UUID` must be unique, and should be prefixed with the plugin's UUID.\n\n\n**Examples:**\n- com.elgato.wavelink.toggle-mute\n- com.elgato.discord.join-voice\n- tv.twitch.go-live",
										pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
										errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
										markdownDescription: "Unique identifier of the action, represented in reverse-DNS format. This value is supplied by Stream Deck when events are emitted that relate to the action enabling you to identify the source of the event.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\nNote: `UUID` must be unique, and should be prefixed with the plugin's UUID.\n\n\n**Examples:**\n- com.elgato.wavelink.toggle-mute\n- com.elgato.discord.join-voice\n- tv.twitch.go-live"
									},
									UserTitleEnabled: {
										type: "boolean",
										description: "Determines whether the title field is available to the user when viewing the action's property inspector. Setting this to `false` will disable the user from specifying a title, thus allowing the plugin to have exclusive access to the title. Default is `true`, i.e. the title field is enabled.",
										markdownDescription: "Determines whether the title field is available to the user when viewing the action's property inspector. Setting this to `false` will disable the user from specifying a title, thus allowing the plugin to have exclusive access to the title. Default is `true`, i.e. the title field is enabled."
									},
									VisibleInActionsList: {
										type: "boolean",
										description: "Determines whether the action is available to users via the actions list in the Stream Deck application. Setting this to `false` allows for the action to be used as part of pre-defined profiles distributed with the plugins, whilst not being available to users. Default is `true`.",
										markdownDescription: "Determines whether the action is available to users via the actions list in the Stream Deck application. Setting this to `false` allows for the action to be used as part of pre-defined profiles distributed with the plugins, whilst not being available to users. Default is `true`."
									}
								},
								required: [
									"Icon",
									"Name",
									"States",
									"UUID"
								],
								additionalProperties: false
							},
							description: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to user's via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`).",
							markdownDescription: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to user's via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`)."
						},
						Profiles: {
							type: "array",
							items: {
								type: "object",
								properties: {
									DeviceType: {
										type: "number",
										"enum": [
											0,
											1,
											2,
											3,
											4,
											5,
											6,
											7,
											8,
											9,
											10,
											11
										],
										description: "Type of device the profile is intended for, for example Stream Deck +, Stream Deck Pedal, etc.\n\n**Devices**\n- Stream Deck (0)\n- Stream Deck Mini (1)\n- Stream Deck XL (2)\n- Stream Deck Mobile (3)\n- Corsair GKeys (4)\n- Stream Deck Pedal (5)\n- Corsair Voyager (6)\n- Stream Deck + (7)\n- SCUF Controller (8)\n- Stream Deck Neo (9)\n- Stream Deck Studio (10)\n- Virtual Stream Deck (11)",
										markdownDescription: "Type of device the profile is intended for, for example Stream Deck +, Stream Deck Pedal, etc.\n\n**Devices**\n- Stream Deck (0)\n- Stream Deck Mini (1)\n- Stream Deck XL (2)\n- Stream Deck Mobile (3)\n- Corsair GKeys (4)\n- Stream Deck Pedal (5)\n- Corsair Voyager (6)\n- Stream Deck + (7)\n- SCUF Controller (8)\n- Stream Deck Neo (9)\n- Stream Deck Studio (10)\n- Virtual Stream Deck (11)"
									},
									DontAutoSwitchWhenInstalled: {
										type: "boolean",
										description: "Determines whether the Stream Deck application should automatically switch to the profile when it is first installed. Default value is `false`.",
										markdownDescription: "Determines whether the Stream Deck application should automatically switch to the profile when it is first installed. Default value is `false`."
									},
									Name: {
										type: "string",
										description: "Path to the `.streamDeckProfile`, with the **file extension omitted**, that contains the profiles layout and action settings.\n\n**Examples:**\n- assets/main-profile\n- profiles/super-cool-profile",
										filePath: {
											extensions: [
												".streamDeckProfile"
											],
											includeExtension: false
										},
										markdownDescription: "Path to the `.streamDeckProfile`, with the **file extension omitted**, that contains the profiles layout and action settings.\n\n**Examples:**\n- assets/main-profile\n- profiles/super-cool-profile",
										pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Tt][Rr][Ee][Aa][Mm][Dd][Ee][Cc][Kk][Pp][Rr][Oo][Ff][Ii][Ll][Ee]))$).*$",
										errorMessage: "String must reference .streamDeckProfile file in the plugin directory, with the file extension omitted."
									},
									Readonly: {
										type: "boolean",
										description: "Determines whether the profile is read-only, or if the user is able to customize it within the Stream Deck application. Default value is `false`.",
										markdownDescription: "Determines whether the profile is read-only, or if the user is able to customize it within the Stream Deck application. Default value is `false`."
									}
								},
								required: [
									"DeviceType",
									"Name"
								],
								additionalProperties: false
							},
							description: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`",
							markdownDescription: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`"
						}
					},
					required: [
						"Actions",
						"Author",
						"CodePath",
						"Description",
						"Icon",
						"Name",
						"OS",
						"SDKVersion",
						"Software",
						"UUID",
						"Version"
					]
				}
			},
			{
				"if": {
					type: "object",
					properties: {
						Software: {
							type: "object",
							description: "Determines the Stream Deck software requirements for this plugin.",
							properties: {
								MinimumVersion: {
									type: "string",
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									"const": "6.5"
								}
							},
							required: [
								"MinimumVersion"
							]
						}
					},
					required: [
						"Software"
					]
				},
				then: {
					type: "object",
					additionalProperties: false,
					properties: {
						$schema: {
							type: "string",
							description: "JSON schema responsible for describing the manifest's data format and validation.",
							markdownDescription: "JSON schema responsible for describing the manifest's data format and validation."
						},
						Actions: {
							type: "array",
							items: {
								type: "object",
								properties: {
									Controllers: {
										type: "array",
										items: {
											$ref: "#/definitions/Controller"
										},
										minItems: 1,
										maxItems: 2,
										description: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +.",
										uniqueItems: true,
										markdownDescription: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +."
									},
									DisableAutomaticStates: {
										type: "boolean",
										description: "Determines whether the state of the action should automatically toggle when the user presses the action; only applies to actions that have more than one state defined. Default is `false`.",
										examples: [
											false
										],
										markdownDescription: "Determines whether the state of the action should automatically toggle when the user presses the action; only applies to actions that have more than one state defined. Default is `false`."
									},
									DisableCaching: {
										type: "boolean",
										description: "Determines whether Stream Deck should cache images associated with the plugin, and its actions. Default is `false`.",
										examples: [
											false
										],
										markdownDescription: "Determines whether Stream Deck should cache images associated with the plugin, and its actions. Default is `false`."
									},
									Encoder: {
										$ref: "#/definitions/Encoder",
										description: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen).",
										markdownDescription: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen)."
									},
									Icon: {
										type: "string",
										description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action in the Stream Deck application's action list.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 20 × 20 px and 40 × 40 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples:**\n- assets/counter\n- imgs/actions/mute",
										filePath: {
											extensions: [
												".svg",
												".png"
											],
											includeExtension: false
										},
										imageDimensions: [
											20,
											20
										],
										markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action in the Stream Deck application's action list.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 20 × 20 px and 40 × 40 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples:**\n- assets/counter\n- imgs/actions/mute",
										pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
										errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
									},
									Name: {
										type: "string",
										description: "Name of the action; this is displayed to the user in the actions list, and is used throughout the Stream Deck application to visually identify the action.",
										markdownDescription: "Name of the action; this is displayed to the user in the actions list, and is used throughout the Stream Deck application to visually identify the action."
									},
									PropertyInspectorPath: {
										type: "string",
										description: "Optional path to the HTML file that represents the property inspector for this action; this is displayed to the user in the Stream Deck application when they add the action, allowing them to configure the action's settings. When `undefined`, the manifest's top-level `PropertyInspectorPath` is used, otherwise none.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n**Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html",
										filePath: {
											extensions: [
												".htm",
												".html"
											],
											includeExtension: true
										},
										markdownDescription: "Optional path to the HTML file that represents the property inspector for this action; this is displayed to the user in the Stream Deck application when they add the action, allowing them to configure the action's settings. When `undefined`, the manifest's top-level `PropertyInspectorPath` is used, otherwise none.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n**Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html",
										pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
										errorMessage: "String must reference .htm, or .html file in the plugin directory."
									},
									States: {
										type: "array",
										items: {
											$ref: "#/definitions/State"
										},
										description: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`.",
										minItems: 1,
										markdownDescription: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`."
									},
									SupportedInMultiActions: {
										type: "boolean",
										description: "Determines whether the action is available to users when they are creating multi-actions. Default is `true`.",
										markdownDescription: "Determines whether the action is available to users when they are creating multi-actions. Default is `true`."
									},
									Tooltip: {
										type: "string",
										description: "Tooltip shown to the user when they hover over the action within the actions list in the Stream Deck application.",
										markdownDescription: "Tooltip shown to the user when they hover over the action within the actions list in the Stream Deck application."
									},
									UUID: {
										type: "string",
										description: "Unique identifier of the action, represented in reverse-DNS format. This value is supplied by Stream Deck when events are emitted that relate to the action enabling you to identify the source of the event.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\nNote: `UUID` must be unique, and should be prefixed with the plugin's UUID.\n\n\n**Examples:**\n- com.elgato.wavelink.toggle-mute\n- com.elgato.discord.join-voice\n- tv.twitch.go-live",
										pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
										errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
										markdownDescription: "Unique identifier of the action, represented in reverse-DNS format. This value is supplied by Stream Deck when events are emitted that relate to the action enabling you to identify the source of the event.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\nNote: `UUID` must be unique, and should be prefixed with the plugin's UUID.\n\n\n**Examples:**\n- com.elgato.wavelink.toggle-mute\n- com.elgato.discord.join-voice\n- tv.twitch.go-live"
									},
									UserTitleEnabled: {
										type: "boolean",
										description: "Determines whether the title field is available to the user when viewing the action's property inspector. Setting this to `false` will disable the user from specifying a title, thus allowing the plugin to have exclusive access to the title. Default is `true`, i.e. the title field is enabled.",
										markdownDescription: "Determines whether the title field is available to the user when viewing the action's property inspector. Setting this to `false` will disable the user from specifying a title, thus allowing the plugin to have exclusive access to the title. Default is `true`, i.e. the title field is enabled."
									},
									VisibleInActionsList: {
										type: "boolean",
										description: "Determines whether the action is available to users via the actions list in the Stream Deck application. Setting this to `false` allows for the action to be used as part of pre-defined profiles distributed with the plugins, whilst not being available to users. Default is `true`.",
										markdownDescription: "Determines whether the action is available to users via the actions list in the Stream Deck application. Setting this to `false` allows for the action to be used as part of pre-defined profiles distributed with the plugins, whilst not being available to users. Default is `true`."
									}
								},
								required: [
									"Icon",
									"Name",
									"States",
									"UUID"
								],
								additionalProperties: false
							},
							description: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to user's via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`).",
							markdownDescription: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to user's via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`)."
						},
						Profiles: {
							type: "array",
							items: {
								type: "object",
								properties: {
									DeviceType: {
										type: "number",
										"enum": [
											0,
											1,
											2,
											3,
											4,
											5,
											6,
											7,
											8,
											9,
											10,
											11
										],
										description: "Type of device the profile is intended for, for example Stream Deck +, Stream Deck Pedal, etc.\n\n**Devices**\n- Stream Deck (0)\n- Stream Deck Mini (1)\n- Stream Deck XL (2)\n- Stream Deck Mobile (3)\n- Corsair GKeys (4)\n- Stream Deck Pedal (5)\n- Corsair Voyager (6)\n- Stream Deck + (7)\n- SCUF Controller (8)\n- Stream Deck Neo (9)\n- Stream Deck Studio (10)\n- Virtual Stream Deck (11)",
										markdownDescription: "Type of device the profile is intended for, for example Stream Deck +, Stream Deck Pedal, etc.\n\n**Devices**\n- Stream Deck (0)\n- Stream Deck Mini (1)\n- Stream Deck XL (2)\n- Stream Deck Mobile (3)\n- Corsair GKeys (4)\n- Stream Deck Pedal (5)\n- Corsair Voyager (6)\n- Stream Deck + (7)\n- SCUF Controller (8)\n- Stream Deck Neo (9)\n- Stream Deck Studio (10)\n- Virtual Stream Deck (11)"
									},
									DontAutoSwitchWhenInstalled: {
										type: "boolean",
										description: "Determines whether the Stream Deck application should automatically switch to the profile when it is first installed. Default value is `false`.",
										markdownDescription: "Determines whether the Stream Deck application should automatically switch to the profile when it is first installed. Default value is `false`."
									},
									Name: {
										type: "string",
										description: "Path to the `.streamDeckProfile`, with the **file extension omitted**, that contains the profiles layout and action settings.\n\n**Examples:**\n- assets/main-profile\n- profiles/super-cool-profile",
										filePath: {
											extensions: [
												".streamDeckProfile"
											],
											includeExtension: false
										},
										markdownDescription: "Path to the `.streamDeckProfile`, with the **file extension omitted**, that contains the profiles layout and action settings.\n\n**Examples:**\n- assets/main-profile\n- profiles/super-cool-profile",
										pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Tt][Rr][Ee][Aa][Mm][Dd][Ee][Cc][Kk][Pp][Rr][Oo][Ff][Ii][Ll][Ee]))$).*$",
										errorMessage: "String must reference .streamDeckProfile file in the plugin directory, with the file extension omitted."
									},
									Readonly: {
										type: "boolean",
										description: "Determines whether the profile is read-only, or if the user is able to customize it within the Stream Deck application. Default value is `false`.",
										markdownDescription: "Determines whether the profile is read-only, or if the user is able to customize it within the Stream Deck application. Default value is `false`."
									}
								},
								required: [
									"DeviceType",
									"Name"
								],
								additionalProperties: false
							},
							description: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`",
							markdownDescription: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`"
						},
						Software: {
							type: "object",
							properties: {
								MinimumVersion: {
									type: "string",
									"const": "6.5",
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									markdownDescription: "Minimum version of the Stream Deck application required for this plugin to run."
								}
							},
							required: [
								"MinimumVersion"
							],
							additionalProperties: false,
							description: "Determines the Stream Deck software requirements for this plugin.",
							markdownDescription: "Determines the Stream Deck software requirements for this plugin."
						},
						ApplicationsToMonitor: {
							$ref: "#/definitions/ApplicationMonitoring",
							description: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`",
							markdownDescription: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`"
						},
						Author: {
							type: "string",
							description: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\".",
							markdownDescription: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\"."
						},
						Category: {
							type: "string",
							description: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group.",
							markdownDescription: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group."
						},
						CategoryIcon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							filePath: {
								extensions: [
									".svg",
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								28,
								28
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
						},
						CodePath: {
							type: "string",
							description: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathMac: {
							type: "string",
							description: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathWin: {
							type: "string",
							description: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						DefaultWindowSize: {
							type: "array",
							items: {
								type: "number"
							},
							minItems: 2,
							maxItems: 2,
							description: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`.",
							examples: [
								[
									500,
									650
								]
							],
							markdownDescription: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`."
						},
						Description: {
							type: "string",
							description: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace.",
							markdownDescription: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace."
						},
						Icon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							filePath: {
								extensions: [
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								256,
								256
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .png file in the plugin directory, with the file extension omitted."
						},
						Name: {
							type: "string",
							description: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc.",
							markdownDescription: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc."
						},
						OS: {
							type: "array",
							items: {
								$ref: "#/definitions/OS"
							},
							minItems: 1,
							maxItems: 2,
							description: "Collection of operating systems, and their minimum required versions, that the plugin supports.",
							markdownDescription: "Collection of operating systems, and their minimum required versions, that the plugin supports."
						},
						PropertyInspectorPath: {
							type: "string",
							description: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							filePath: {
								extensions: [
									".htm",
									".html"
								],
								includeExtension: true
							},
							markdownDescription: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
							errorMessage: "String must reference .htm, or .html file in the plugin directory."
						},
						URL: {
							type: "string",
							description: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com",
							markdownDescription: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com"
						},
						UUID: {
							type: "string",
							description: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch",
							pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
							errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
							markdownDescription: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch"
						},
						Version: {
							type: "string",
							description: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`.",
							examples: [
								"1.0.0.0"
							],
							pattern: "^(0|[1-9]\\d*)(\\.(0|[1-9]\\d*)){3}$",
							errorMessage: "String must use format {major}.{minor}.{patch}.{build}",
							markdownDescription: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`."
						},
						Nodejs: {
							type: "object",
							additionalProperties: false,
							properties: {
								Version: {
									type: "string",
									"const": "20",
									description: "Version of Node.js to use.",
									markdownDescription: "Version of Node.js to use."
								},
								Debug: {
									type: "string",
									description: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`.",
									examples: [
										"enabled",
										"break"
									],
									markdownDescription: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`."
								},
								GenerateProfilerOutput: {
									type: "boolean",
									description: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling).",
									markdownDescription: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling)."
								}
							},
							required: [
								"Version"
							],
							description: "Configuration options for Node.js based plugins.",
							markdownDescription: "Configuration options for Node.js based plugins."
						},
						SDKVersion: {
							type: "number",
							"const": 2,
							description: "Preferred SDK version; this should _currently_ always be 2.",
							markdownDescription: "Preferred SDK version; this should _currently_ always be 2."
						}
					},
					required: [
						"Actions",
						"Author",
						"CodePath",
						"Description",
						"Icon",
						"Name",
						"OS",
						"SDKVersion",
						"Software",
						"UUID",
						"Version"
					]
				}
			},
			{
				"if": {
					type: "object",
					properties: {
						Software: {
							type: "object",
							description: "Determines the Stream Deck software requirements for this plugin.",
							properties: {
								MinimumVersion: {
									type: "string",
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									"const": "6.6"
								}
							},
							required: [
								"MinimumVersion"
							]
						}
					},
					required: [
						"Software"
					]
				},
				then: {
					type: "object",
					additionalProperties: false,
					properties: {
						$schema: {
							type: "string",
							description: "JSON schema responsible for describing the manifest's data format and validation.",
							markdownDescription: "JSON schema responsible for describing the manifest's data format and validation."
						},
						Actions: {
							type: "array",
							items: {
								type: "object",
								properties: {
									Controllers: {
										type: "array",
										items: {
											$ref: "#/definitions/Controller"
										},
										minItems: 1,
										maxItems: 2,
										description: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +.",
										uniqueItems: true,
										markdownDescription: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +."
									},
									DisableAutomaticStates: {
										type: "boolean",
										description: "Determines whether the state of the action should automatically toggle when the user presses the action; only applies to actions that have more than one state defined. Default is `false`.",
										examples: [
											false
										],
										markdownDescription: "Determines whether the state of the action should automatically toggle when the user presses the action; only applies to actions that have more than one state defined. Default is `false`."
									},
									DisableCaching: {
										type: "boolean",
										description: "Determines whether Stream Deck should cache images associated with the plugin, and its actions. Default is `false`.",
										examples: [
											false
										],
										markdownDescription: "Determines whether Stream Deck should cache images associated with the plugin, and its actions. Default is `false`."
									},
									Encoder: {
										$ref: "#/definitions/Encoder",
										description: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen).",
										markdownDescription: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen)."
									},
									Icon: {
										type: "string",
										description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action in the Stream Deck application's action list.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 20 × 20 px and 40 × 40 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples:**\n- assets/counter\n- imgs/actions/mute",
										filePath: {
											extensions: [
												".svg",
												".png"
											],
											includeExtension: false
										},
										imageDimensions: [
											20,
											20
										],
										markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action in the Stream Deck application's action list.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 20 × 20 px and 40 × 40 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples:**\n- assets/counter\n- imgs/actions/mute",
										pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
										errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
									},
									Name: {
										type: "string",
										description: "Name of the action; this is displayed to the user in the actions list, and is used throughout the Stream Deck application to visually identify the action.",
										markdownDescription: "Name of the action; this is displayed to the user in the actions list, and is used throughout the Stream Deck application to visually identify the action."
									},
									OS: {
										type: "array",
										items: {
											type: "string",
											"enum": [
												"mac",
												"windows"
											]
										},
										description: "Operating system that the action supports.",
										minItems: 1,
										maxItems: 2,
										uniqueItems: true,
										markdownDescription: "Operating system that the action supports."
									},
									PropertyInspectorPath: {
										type: "string",
										description: "Optional path to the HTML file that represents the property inspector for this action; this is displayed to the user in the Stream Deck application when they add the action, allowing them to configure the action's settings. When `undefined`, the manifest's top-level `PropertyInspectorPath` is used, otherwise none.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n**Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html",
										filePath: {
											extensions: [
												".htm",
												".html"
											],
											includeExtension: true
										},
										markdownDescription: "Optional path to the HTML file that represents the property inspector for this action; this is displayed to the user in the Stream Deck application when they add the action, allowing them to configure the action's settings. When `undefined`, the manifest's top-level `PropertyInspectorPath` is used, otherwise none.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n**Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html",
										pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
										errorMessage: "String must reference .htm, or .html file in the plugin directory."
									},
									States: {
										type: "array",
										items: {
											$ref: "#/definitions/State"
										},
										description: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`.",
										minItems: 1,
										markdownDescription: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`."
									},
									SupportedInMultiActions: {
										type: "boolean",
										description: "Determines whether the action is available to users when they are creating multi-actions. Default is `true`.",
										markdownDescription: "Determines whether the action is available to users when they are creating multi-actions. Default is `true`."
									},
									Tooltip: {
										type: "string",
										description: "Tooltip shown to the user when they hover over the action within the actions list in the Stream Deck application.",
										markdownDescription: "Tooltip shown to the user when they hover over the action within the actions list in the Stream Deck application."
									},
									UUID: {
										type: "string",
										description: "Unique identifier of the action, represented in reverse-DNS format. This value is supplied by Stream Deck when events are emitted that relate to the action enabling you to identify the source of the event.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\nNote: `UUID` must be unique, and should be prefixed with the plugin's UUID.\n\n\n**Examples:**\n- com.elgato.wavelink.toggle-mute\n- com.elgato.discord.join-voice\n- tv.twitch.go-live",
										pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
										errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
										markdownDescription: "Unique identifier of the action, represented in reverse-DNS format. This value is supplied by Stream Deck when events are emitted that relate to the action enabling you to identify the source of the event.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\nNote: `UUID` must be unique, and should be prefixed with the plugin's UUID.\n\n\n**Examples:**\n- com.elgato.wavelink.toggle-mute\n- com.elgato.discord.join-voice\n- tv.twitch.go-live"
									},
									UserTitleEnabled: {
										type: "boolean",
										description: "Determines whether the title field is available to the user when viewing the action's property inspector. Setting this to `false` will disable the user from specifying a title, thus allowing the plugin to have exclusive access to the title. Default is `true`, i.e. the title field is enabled.",
										markdownDescription: "Determines whether the title field is available to the user when viewing the action's property inspector. Setting this to `false` will disable the user from specifying a title, thus allowing the plugin to have exclusive access to the title. Default is `true`, i.e. the title field is enabled."
									},
									VisibleInActionsList: {
										type: "boolean",
										description: "Determines whether the action is available to users via the actions list in the Stream Deck application. Setting this to `false` allows for the action to be used as part of pre-defined profiles distributed with the plugins, whilst not being available to users. Default is `true`.",
										markdownDescription: "Determines whether the action is available to users via the actions list in the Stream Deck application. Setting this to `false` allows for the action to be used as part of pre-defined profiles distributed with the plugins, whilst not being available to users. Default is `true`."
									}
								},
								required: [
									"Icon",
									"Name",
									"States",
									"UUID"
								],
								additionalProperties: false
							},
							description: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to user's via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`).",
							markdownDescription: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to user's via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`)."
						},
						Software: {
							type: "object",
							properties: {
								MinimumVersion: {
									type: "string",
									"enum": [
										"6.6",
										"6.7",
										"6.8"
									],
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									markdownDescription: "Minimum version of the Stream Deck application required for this plugin to run."
								}
							},
							required: [
								"MinimumVersion"
							],
							additionalProperties: false,
							description: "Determines the Stream Deck software requirements for this plugin.",
							markdownDescription: "Determines the Stream Deck software requirements for this plugin."
						},
						SDKVersion: {
							type: "number",
							"const": 2,
							description: "Preferred SDK version; this should _currently_ always be 2.",
							markdownDescription: "Preferred SDK version; this should _currently_ always be 2."
						},
						ApplicationsToMonitor: {
							$ref: "#/definitions/ApplicationMonitoring",
							description: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`",
							markdownDescription: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`"
						},
						Author: {
							type: "string",
							description: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\".",
							markdownDescription: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\"."
						},
						Category: {
							type: "string",
							description: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group.",
							markdownDescription: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group."
						},
						CategoryIcon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							filePath: {
								extensions: [
									".svg",
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								28,
								28
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
						},
						CodePath: {
							type: "string",
							description: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathMac: {
							type: "string",
							description: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathWin: {
							type: "string",
							description: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						DefaultWindowSize: {
							type: "array",
							items: {
								type: "number"
							},
							minItems: 2,
							maxItems: 2,
							description: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`.",
							examples: [
								[
									500,
									650
								]
							],
							markdownDescription: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`."
						},
						Description: {
							type: "string",
							description: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace.",
							markdownDescription: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace."
						},
						Icon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							filePath: {
								extensions: [
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								256,
								256
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .png file in the plugin directory, with the file extension omitted."
						},
						Name: {
							type: "string",
							description: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc.",
							markdownDescription: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc."
						},
						OS: {
							type: "array",
							items: {
								$ref: "#/definitions/OS"
							},
							minItems: 1,
							maxItems: 2,
							description: "Collection of operating systems, and their minimum required versions, that the plugin supports.",
							markdownDescription: "Collection of operating systems, and their minimum required versions, that the plugin supports."
						},
						Profiles: {
							type: "array",
							items: {
								$ref: "#/definitions/Profile"
							},
							description: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`",
							markdownDescription: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`"
						},
						PropertyInspectorPath: {
							type: "string",
							description: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							filePath: {
								extensions: [
									".htm",
									".html"
								],
								includeExtension: true
							},
							markdownDescription: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
							errorMessage: "String must reference .htm, or .html file in the plugin directory."
						},
						URL: {
							type: "string",
							description: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com",
							markdownDescription: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com"
						},
						UUID: {
							type: "string",
							description: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch",
							pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
							errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
							markdownDescription: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch"
						},
						Version: {
							type: "string",
							description: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`.",
							examples: [
								"1.0.0.0"
							],
							pattern: "^(0|[1-9]\\d*)(\\.(0|[1-9]\\d*)){3}$",
							errorMessage: "String must use format {major}.{minor}.{patch}.{build}",
							markdownDescription: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`."
						},
						Nodejs: {
							type: "object",
							additionalProperties: false,
							properties: {
								Version: {
									type: "string",
									"const": "20",
									description: "Version of Node.js to use.",
									markdownDescription: "Version of Node.js to use."
								},
								Debug: {
									type: "string",
									description: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`.",
									examples: [
										"enabled",
										"break"
									],
									markdownDescription: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`."
								},
								GenerateProfilerOutput: {
									type: "boolean",
									description: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling).",
									markdownDescription: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling)."
								}
							},
							required: [
								"Version"
							],
							description: "Configuration options for Node.js based plugins.",
							markdownDescription: "Configuration options for Node.js based plugins."
						}
					},
					required: [
						"Actions",
						"Author",
						"CodePath",
						"Description",
						"Icon",
						"Name",
						"OS",
						"SDKVersion",
						"Software",
						"UUID",
						"Version"
					]
				}
			},
			{
				"if": {
					type: "object",
					properties: {
						Software: {
							type: "object",
							description: "Determines the Stream Deck software requirements for this plugin.",
							properties: {
								MinimumVersion: {
									type: "string",
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									"const": "6.7"
								}
							},
							required: [
								"MinimumVersion"
							]
						}
					},
					required: [
						"Software"
					]
				},
				then: {
					type: "object",
					additionalProperties: false,
					properties: {
						$schema: {
							type: "string",
							description: "JSON schema responsible for describing the manifest's data format and validation.",
							markdownDescription: "JSON schema responsible for describing the manifest's data format and validation."
						},
						Actions: {
							type: "array",
							items: {
								type: "object",
								properties: {
									Controllers: {
										type: "array",
										items: {
											$ref: "#/definitions/Controller"
										},
										minItems: 1,
										maxItems: 2,
										description: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +.",
										uniqueItems: true,
										markdownDescription: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +."
									},
									DisableAutomaticStates: {
										type: "boolean",
										description: "Determines whether the state of the action should automatically toggle when the user presses the action; only applies to actions that have more than one state defined. Default is `false`.",
										examples: [
											false
										],
										markdownDescription: "Determines whether the state of the action should automatically toggle when the user presses the action; only applies to actions that have more than one state defined. Default is `false`."
									},
									DisableCaching: {
										type: "boolean",
										description: "Determines whether Stream Deck should cache images associated with the plugin, and its actions. Default is `false`.",
										examples: [
											false
										],
										markdownDescription: "Determines whether Stream Deck should cache images associated with the plugin, and its actions. Default is `false`."
									},
									Encoder: {
										$ref: "#/definitions/Encoder",
										description: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen).",
										markdownDescription: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen)."
									},
									Icon: {
										type: "string",
										description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action in the Stream Deck application's action list.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 20 × 20 px and 40 × 40 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples:**\n- assets/counter\n- imgs/actions/mute",
										filePath: {
											extensions: [
												".svg",
												".png"
											],
											includeExtension: false
										},
										imageDimensions: [
											20,
											20
										],
										markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action in the Stream Deck application's action list.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 20 × 20 px and 40 × 40 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples:**\n- assets/counter\n- imgs/actions/mute",
										pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
										errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
									},
									Name: {
										type: "string",
										description: "Name of the action; this is displayed to the user in the actions list, and is used throughout the Stream Deck application to visually identify the action.",
										markdownDescription: "Name of the action; this is displayed to the user in the actions list, and is used throughout the Stream Deck application to visually identify the action."
									},
									OS: {
										type: "array",
										items: {
											type: "string",
											"enum": [
												"mac",
												"windows"
											]
										},
										description: "Operating system that the action supports.",
										minItems: 1,
										maxItems: 2,
										uniqueItems: true,
										markdownDescription: "Operating system that the action supports."
									},
									PropertyInspectorPath: {
										type: "string",
										description: "Optional path to the HTML file that represents the property inspector for this action; this is displayed to the user in the Stream Deck application when they add the action, allowing them to configure the action's settings. When `undefined`, the manifest's top-level `PropertyInspectorPath` is used, otherwise none.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n**Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html",
										filePath: {
											extensions: [
												".htm",
												".html"
											],
											includeExtension: true
										},
										markdownDescription: "Optional path to the HTML file that represents the property inspector for this action; this is displayed to the user in the Stream Deck application when they add the action, allowing them to configure the action's settings. When `undefined`, the manifest's top-level `PropertyInspectorPath` is used, otherwise none.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n**Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html",
										pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
										errorMessage: "String must reference .htm, or .html file in the plugin directory."
									},
									States: {
										type: "array",
										items: {
											$ref: "#/definitions/State"
										},
										description: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`.",
										minItems: 1,
										markdownDescription: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`."
									},
									SupportedInMultiActions: {
										type: "boolean",
										description: "Determines whether the action is available to users when they are creating multi-actions. Default is `true`.",
										markdownDescription: "Determines whether the action is available to users when they are creating multi-actions. Default is `true`."
									},
									Tooltip: {
										type: "string",
										description: "Tooltip shown to the user when they hover over the action within the actions list in the Stream Deck application.",
										markdownDescription: "Tooltip shown to the user when they hover over the action within the actions list in the Stream Deck application."
									},
									UUID: {
										type: "string",
										description: "Unique identifier of the action, represented in reverse-DNS format. This value is supplied by Stream Deck when events are emitted that relate to the action enabling you to identify the source of the event.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\nNote: `UUID` must be unique, and should be prefixed with the plugin's UUID.\n\n\n**Examples:**\n- com.elgato.wavelink.toggle-mute\n- com.elgato.discord.join-voice\n- tv.twitch.go-live",
										pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
										errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
										markdownDescription: "Unique identifier of the action, represented in reverse-DNS format. This value is supplied by Stream Deck when events are emitted that relate to the action enabling you to identify the source of the event.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\nNote: `UUID` must be unique, and should be prefixed with the plugin's UUID.\n\n\n**Examples:**\n- com.elgato.wavelink.toggle-mute\n- com.elgato.discord.join-voice\n- tv.twitch.go-live"
									},
									UserTitleEnabled: {
										type: "boolean",
										description: "Determines whether the title field is available to the user when viewing the action's property inspector. Setting this to `false` will disable the user from specifying a title, thus allowing the plugin to have exclusive access to the title. Default is `true`, i.e. the title field is enabled.",
										markdownDescription: "Determines whether the title field is available to the user when viewing the action's property inspector. Setting this to `false` will disable the user from specifying a title, thus allowing the plugin to have exclusive access to the title. Default is `true`, i.e. the title field is enabled."
									},
									VisibleInActionsList: {
										type: "boolean",
										description: "Determines whether the action is available to users via the actions list in the Stream Deck application. Setting this to `false` allows for the action to be used as part of pre-defined profiles distributed with the plugins, whilst not being available to users. Default is `true`.",
										markdownDescription: "Determines whether the action is available to users via the actions list in the Stream Deck application. Setting this to `false` allows for the action to be used as part of pre-defined profiles distributed with the plugins, whilst not being available to users. Default is `true`."
									}
								},
								required: [
									"Icon",
									"Name",
									"States",
									"UUID"
								],
								additionalProperties: false
							},
							description: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to user's via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`).",
							markdownDescription: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to user's via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`)."
						},
						Software: {
							type: "object",
							properties: {
								MinimumVersion: {
									type: "string",
									"enum": [
										"6.6",
										"6.7",
										"6.8"
									],
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									markdownDescription: "Minimum version of the Stream Deck application required for this plugin to run."
								}
							},
							required: [
								"MinimumVersion"
							],
							additionalProperties: false,
							description: "Determines the Stream Deck software requirements for this plugin.",
							markdownDescription: "Determines the Stream Deck software requirements for this plugin."
						},
						SDKVersion: {
							type: "number",
							"const": 2,
							description: "Preferred SDK version; this should _currently_ always be 2.",
							markdownDescription: "Preferred SDK version; this should _currently_ always be 2."
						},
						ApplicationsToMonitor: {
							$ref: "#/definitions/ApplicationMonitoring",
							description: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`",
							markdownDescription: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`"
						},
						Author: {
							type: "string",
							description: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\".",
							markdownDescription: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\"."
						},
						Category: {
							type: "string",
							description: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group.",
							markdownDescription: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group."
						},
						CategoryIcon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							filePath: {
								extensions: [
									".svg",
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								28,
								28
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
						},
						CodePath: {
							type: "string",
							description: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathMac: {
							type: "string",
							description: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathWin: {
							type: "string",
							description: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						DefaultWindowSize: {
							type: "array",
							items: {
								type: "number"
							},
							minItems: 2,
							maxItems: 2,
							description: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`.",
							examples: [
								[
									500,
									650
								]
							],
							markdownDescription: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`."
						},
						Description: {
							type: "string",
							description: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace.",
							markdownDescription: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace."
						},
						Icon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							filePath: {
								extensions: [
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								256,
								256
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .png file in the plugin directory, with the file extension omitted."
						},
						Name: {
							type: "string",
							description: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc.",
							markdownDescription: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc."
						},
						OS: {
							type: "array",
							items: {
								$ref: "#/definitions/OS"
							},
							minItems: 1,
							maxItems: 2,
							description: "Collection of operating systems, and their minimum required versions, that the plugin supports.",
							markdownDescription: "Collection of operating systems, and their minimum required versions, that the plugin supports."
						},
						Profiles: {
							type: "array",
							items: {
								$ref: "#/definitions/Profile"
							},
							description: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`",
							markdownDescription: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`"
						},
						PropertyInspectorPath: {
							type: "string",
							description: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							filePath: {
								extensions: [
									".htm",
									".html"
								],
								includeExtension: true
							},
							markdownDescription: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
							errorMessage: "String must reference .htm, or .html file in the plugin directory."
						},
						URL: {
							type: "string",
							description: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com",
							markdownDescription: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com"
						},
						UUID: {
							type: "string",
							description: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch",
							pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
							errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
							markdownDescription: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch"
						},
						Version: {
							type: "string",
							description: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`.",
							examples: [
								"1.0.0.0"
							],
							pattern: "^(0|[1-9]\\d*)(\\.(0|[1-9]\\d*)){3}$",
							errorMessage: "String must use format {major}.{minor}.{patch}.{build}",
							markdownDescription: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`."
						},
						Nodejs: {
							type: "object",
							additionalProperties: false,
							properties: {
								Version: {
									type: "string",
									"const": "20",
									description: "Version of Node.js to use.",
									markdownDescription: "Version of Node.js to use."
								},
								Debug: {
									type: "string",
									description: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`.",
									examples: [
										"enabled",
										"break"
									],
									markdownDescription: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`."
								},
								GenerateProfilerOutput: {
									type: "boolean",
									description: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling).",
									markdownDescription: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling)."
								}
							},
							required: [
								"Version"
							],
							description: "Configuration options for Node.js based plugins.",
							markdownDescription: "Configuration options for Node.js based plugins."
						}
					},
					required: [
						"Actions",
						"Author",
						"CodePath",
						"Description",
						"Icon",
						"Name",
						"OS",
						"SDKVersion",
						"Software",
						"UUID",
						"Version"
					]
				}
			},
			{
				"if": {
					type: "object",
					properties: {
						Software: {
							type: "object",
							description: "Determines the Stream Deck software requirements for this plugin.",
							properties: {
								MinimumVersion: {
									type: "string",
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									"const": "6.8"
								}
							},
							required: [
								"MinimumVersion"
							]
						}
					},
					required: [
						"Software"
					]
				},
				then: {
					type: "object",
					additionalProperties: false,
					properties: {
						$schema: {
							type: "string",
							description: "JSON schema responsible for describing the manifest's data format and validation.",
							markdownDescription: "JSON schema responsible for describing the manifest's data format and validation."
						},
						Actions: {
							type: "array",
							items: {
								type: "object",
								properties: {
									Controllers: {
										type: "array",
										items: {
											$ref: "#/definitions/Controller"
										},
										minItems: 1,
										maxItems: 2,
										description: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +.",
										uniqueItems: true,
										markdownDescription: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +."
									},
									DisableAutomaticStates: {
										type: "boolean",
										description: "Determines whether the state of the action should automatically toggle when the user presses the action; only applies to actions that have more than one state defined. Default is `false`.",
										examples: [
											false
										],
										markdownDescription: "Determines whether the state of the action should automatically toggle when the user presses the action; only applies to actions that have more than one state defined. Default is `false`."
									},
									DisableCaching: {
										type: "boolean",
										description: "Determines whether Stream Deck should cache images associated with the plugin, and its actions. Default is `false`.",
										examples: [
											false
										],
										markdownDescription: "Determines whether Stream Deck should cache images associated with the plugin, and its actions. Default is `false`."
									},
									Encoder: {
										$ref: "#/definitions/Encoder",
										description: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen).",
										markdownDescription: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen)."
									},
									Icon: {
										type: "string",
										description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action in the Stream Deck application's action list.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 20 × 20 px and 40 × 40 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples:**\n- assets/counter\n- imgs/actions/mute",
										filePath: {
											extensions: [
												".svg",
												".png"
											],
											includeExtension: false
										},
										imageDimensions: [
											20,
											20
										],
										markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action in the Stream Deck application's action list.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 20 × 20 px and 40 × 40 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples:**\n- assets/counter\n- imgs/actions/mute",
										pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
										errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
									},
									Name: {
										type: "string",
										description: "Name of the action; this is displayed to the user in the actions list, and is used throughout the Stream Deck application to visually identify the action.",
										markdownDescription: "Name of the action; this is displayed to the user in the actions list, and is used throughout the Stream Deck application to visually identify the action."
									},
									OS: {
										type: "array",
										items: {
											type: "string",
											"enum": [
												"mac",
												"windows"
											]
										},
										description: "Operating system that the action supports.",
										minItems: 1,
										maxItems: 2,
										uniqueItems: true,
										markdownDescription: "Operating system that the action supports."
									},
									PropertyInspectorPath: {
										type: "string",
										description: "Optional path to the HTML file that represents the property inspector for this action; this is displayed to the user in the Stream Deck application when they add the action, allowing them to configure the action's settings. When `undefined`, the manifest's top-level `PropertyInspectorPath` is used, otherwise none.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n**Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html",
										filePath: {
											extensions: [
												".htm",
												".html"
											],
											includeExtension: true
										},
										markdownDescription: "Optional path to the HTML file that represents the property inspector for this action; this is displayed to the user in the Stream Deck application when they add the action, allowing them to configure the action's settings. When `undefined`, the manifest's top-level `PropertyInspectorPath` is used, otherwise none.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n**Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html",
										pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
										errorMessage: "String must reference .htm, or .html file in the plugin directory."
									},
									States: {
										type: "array",
										items: {
											$ref: "#/definitions/State"
										},
										description: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`.",
										minItems: 1,
										markdownDescription: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`."
									},
									SupportedInMultiActions: {
										type: "boolean",
										description: "Determines whether the action is available to users when they are creating multi-actions. Default is `true`.",
										markdownDescription: "Determines whether the action is available to users when they are creating multi-actions. Default is `true`."
									},
									Tooltip: {
										type: "string",
										description: "Tooltip shown to the user when they hover over the action within the actions list in the Stream Deck application.",
										markdownDescription: "Tooltip shown to the user when they hover over the action within the actions list in the Stream Deck application."
									},
									UUID: {
										type: "string",
										description: "Unique identifier of the action, represented in reverse-DNS format. This value is supplied by Stream Deck when events are emitted that relate to the action enabling you to identify the source of the event.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\nNote: `UUID` must be unique, and should be prefixed with the plugin's UUID.\n\n\n**Examples:**\n- com.elgato.wavelink.toggle-mute\n- com.elgato.discord.join-voice\n- tv.twitch.go-live",
										pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
										errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
										markdownDescription: "Unique identifier of the action, represented in reverse-DNS format. This value is supplied by Stream Deck when events are emitted that relate to the action enabling you to identify the source of the event.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\nNote: `UUID` must be unique, and should be prefixed with the plugin's UUID.\n\n\n**Examples:**\n- com.elgato.wavelink.toggle-mute\n- com.elgato.discord.join-voice\n- tv.twitch.go-live"
									},
									UserTitleEnabled: {
										type: "boolean",
										description: "Determines whether the title field is available to the user when viewing the action's property inspector. Setting this to `false` will disable the user from specifying a title, thus allowing the plugin to have exclusive access to the title. Default is `true`, i.e. the title field is enabled.",
										markdownDescription: "Determines whether the title field is available to the user when viewing the action's property inspector. Setting this to `false` will disable the user from specifying a title, thus allowing the plugin to have exclusive access to the title. Default is `true`, i.e. the title field is enabled."
									},
									VisibleInActionsList: {
										type: "boolean",
										description: "Determines whether the action is available to users via the actions list in the Stream Deck application. Setting this to `false` allows for the action to be used as part of pre-defined profiles distributed with the plugins, whilst not being available to users. Default is `true`.",
										markdownDescription: "Determines whether the action is available to users via the actions list in the Stream Deck application. Setting this to `false` allows for the action to be used as part of pre-defined profiles distributed with the plugins, whilst not being available to users. Default is `true`."
									}
								},
								required: [
									"Icon",
									"Name",
									"States",
									"UUID"
								],
								additionalProperties: false
							},
							description: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to user's via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`).",
							markdownDescription: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to user's via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`)."
						},
						Software: {
							type: "object",
							properties: {
								MinimumVersion: {
									type: "string",
									"enum": [
										"6.6",
										"6.7",
										"6.8"
									],
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									markdownDescription: "Minimum version of the Stream Deck application required for this plugin to run."
								}
							},
							required: [
								"MinimumVersion"
							],
							additionalProperties: false,
							description: "Determines the Stream Deck software requirements for this plugin.",
							markdownDescription: "Determines the Stream Deck software requirements for this plugin."
						},
						SDKVersion: {
							type: "number",
							"const": 2,
							description: "Preferred SDK version; this should _currently_ always be 2.",
							markdownDescription: "Preferred SDK version; this should _currently_ always be 2."
						},
						ApplicationsToMonitor: {
							$ref: "#/definitions/ApplicationMonitoring",
							description: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`",
							markdownDescription: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`"
						},
						Author: {
							type: "string",
							description: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\".",
							markdownDescription: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\"."
						},
						Category: {
							type: "string",
							description: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group.",
							markdownDescription: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group."
						},
						CategoryIcon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							filePath: {
								extensions: [
									".svg",
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								28,
								28
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
						},
						CodePath: {
							type: "string",
							description: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathMac: {
							type: "string",
							description: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathWin: {
							type: "string",
							description: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						DefaultWindowSize: {
							type: "array",
							items: {
								type: "number"
							},
							minItems: 2,
							maxItems: 2,
							description: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`.",
							examples: [
								[
									500,
									650
								]
							],
							markdownDescription: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`."
						},
						Description: {
							type: "string",
							description: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace.",
							markdownDescription: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace."
						},
						Icon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							filePath: {
								extensions: [
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								256,
								256
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .png file in the plugin directory, with the file extension omitted."
						},
						Name: {
							type: "string",
							description: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc.",
							markdownDescription: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc."
						},
						OS: {
							type: "array",
							items: {
								$ref: "#/definitions/OS"
							},
							minItems: 1,
							maxItems: 2,
							description: "Collection of operating systems, and their minimum required versions, that the plugin supports.",
							markdownDescription: "Collection of operating systems, and their minimum required versions, that the plugin supports."
						},
						Profiles: {
							type: "array",
							items: {
								$ref: "#/definitions/Profile"
							},
							description: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`",
							markdownDescription: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`"
						},
						PropertyInspectorPath: {
							type: "string",
							description: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							filePath: {
								extensions: [
									".htm",
									".html"
								],
								includeExtension: true
							},
							markdownDescription: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
							errorMessage: "String must reference .htm, or .html file in the plugin directory."
						},
						URL: {
							type: "string",
							description: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com",
							markdownDescription: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com"
						},
						UUID: {
							type: "string",
							description: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch",
							pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
							errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
							markdownDescription: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch"
						},
						Version: {
							type: "string",
							description: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`.",
							examples: [
								"1.0.0.0"
							],
							pattern: "^(0|[1-9]\\d*)(\\.(0|[1-9]\\d*)){3}$",
							errorMessage: "String must use format {major}.{minor}.{patch}.{build}",
							markdownDescription: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`."
						},
						Nodejs: {
							type: "object",
							additionalProperties: false,
							properties: {
								Version: {
									type: "string",
									"const": "20",
									description: "Version of Node.js to use.",
									markdownDescription: "Version of Node.js to use."
								},
								Debug: {
									type: "string",
									description: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`.",
									examples: [
										"enabled",
										"break"
									],
									markdownDescription: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`."
								},
								GenerateProfilerOutput: {
									type: "boolean",
									description: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling).",
									markdownDescription: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling)."
								}
							},
							required: [
								"Version"
							],
							description: "Configuration options for Node.js based plugins.",
							markdownDescription: "Configuration options for Node.js based plugins."
						}
					},
					required: [
						"Actions",
						"Author",
						"CodePath",
						"Description",
						"Icon",
						"Name",
						"OS",
						"SDKVersion",
						"Software",
						"UUID",
						"Version"
					]
				}
			},
			{
				"if": {
					type: "object",
					properties: {
						Software: {
							type: "object",
							description: "Determines the Stream Deck software requirements for this plugin.",
							properties: {
								MinimumVersion: {
									type: "string",
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									"const": "6.9"
								}
							},
							required: [
								"MinimumVersion"
							]
						}
					},
					required: [
						"Software"
					]
				},
				then: {
					type: "object",
					additionalProperties: false,
					properties: {
						$schema: {
							type: "string",
							description: "JSON schema responsible for describing the manifest's data format and validation.",
							markdownDescription: "JSON schema responsible for describing the manifest's data format and validation."
						},
						Actions: {
							type: "array",
							items: {
								type: "object",
								properties: {
									Controllers: {
										type: "array",
										items: {
											$ref: "#/definitions/Controller"
										},
										minItems: 1,
										maxItems: 2,
										description: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +.",
										uniqueItems: true,
										markdownDescription: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +."
									},
									DisableAutomaticStates: {
										type: "boolean",
										description: "Determines whether the state of the action should automatically toggle when the user presses the action; only applies to actions that have more than one state defined. Default is `false`.",
										examples: [
											false
										],
										markdownDescription: "Determines whether the state of the action should automatically toggle when the user presses the action; only applies to actions that have more than one state defined. Default is `false`."
									},
									DisableCaching: {
										type: "boolean",
										description: "Determines whether Stream Deck should cache images associated with the plugin, and its actions. Default is `false`.",
										examples: [
											false
										],
										markdownDescription: "Determines whether Stream Deck should cache images associated with the plugin, and its actions. Default is `false`."
									},
									Encoder: {
										$ref: "#/definitions/Encoder",
										description: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen).",
										markdownDescription: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen)."
									},
									Icon: {
										type: "string",
										description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action in the Stream Deck application's action list.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 20 × 20 px and 40 × 40 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples:**\n- assets/counter\n- imgs/actions/mute",
										filePath: {
											extensions: [
												".svg",
												".png"
											],
											includeExtension: false
										},
										imageDimensions: [
											20,
											20
										],
										markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action in the Stream Deck application's action list.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 20 × 20 px and 40 × 40 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples:**\n- assets/counter\n- imgs/actions/mute",
										pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
										errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
									},
									Name: {
										type: "string",
										description: "Name of the action; this is displayed to the user in the actions list, and is used throughout the Stream Deck application to visually identify the action.",
										markdownDescription: "Name of the action; this is displayed to the user in the actions list, and is used throughout the Stream Deck application to visually identify the action."
									},
									OS: {
										type: "array",
										items: {
											type: "string",
											"enum": [
												"mac",
												"windows"
											]
										},
										description: "Operating system that the action supports.",
										minItems: 1,
										maxItems: 2,
										uniqueItems: true,
										markdownDescription: "Operating system that the action supports."
									},
									PropertyInspectorPath: {
										type: "string",
										description: "Optional path to the HTML file that represents the property inspector for this action; this is displayed to the user in the Stream Deck application when they add the action, allowing them to configure the action's settings. When `undefined`, the manifest's top-level `PropertyInspectorPath` is used, otherwise none.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n**Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html",
										filePath: {
											extensions: [
												".htm",
												".html"
											],
											includeExtension: true
										},
										markdownDescription: "Optional path to the HTML file that represents the property inspector for this action; this is displayed to the user in the Stream Deck application when they add the action, allowing them to configure the action's settings. When `undefined`, the manifest's top-level `PropertyInspectorPath` is used, otherwise none.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n**Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html",
										pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
										errorMessage: "String must reference .htm, or .html file in the plugin directory."
									},
									States: {
										type: "array",
										items: {
											$ref: "#/definitions/State"
										},
										description: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`.",
										minItems: 1,
										markdownDescription: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`."
									},
									SupportedInMultiActions: {
										type: "boolean",
										description: "Determines whether the action is available to users when they are creating multi-actions. Default is `true`.",
										markdownDescription: "Determines whether the action is available to users when they are creating multi-actions. Default is `true`."
									},
									SupportURL: {
										type: "string",
										description: "Link to the actions's support website.\n\n**Examples**:\n- https://help.corsair.com/\n- https://help.elgato.com/\n\nAvailable from Stream Deck 6.9.",
										markdownDescription: "Link to the actions's support website.\n\n**Examples**:\n- https://help.corsair.com/\n- https://help.elgato.com/\n\nAvailable from Stream Deck 6.9."
									},
									Tooltip: {
										type: "string",
										description: "Tooltip shown to the user when they hover over the action within the actions list in the Stream Deck application.",
										markdownDescription: "Tooltip shown to the user when they hover over the action within the actions list in the Stream Deck application."
									},
									UUID: {
										type: "string",
										description: "Unique identifier of the action, represented in reverse-DNS format. This value is supplied by Stream Deck when events are emitted that relate to the action enabling you to identify the source of the event.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\nNote: `UUID` must be unique, and should be prefixed with the plugin's UUID.\n\n\n**Examples:**\n- com.elgato.wavelink.toggle-mute\n- com.elgato.discord.join-voice\n- tv.twitch.go-live",
										pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
										errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
										markdownDescription: "Unique identifier of the action, represented in reverse-DNS format. This value is supplied by Stream Deck when events are emitted that relate to the action enabling you to identify the source of the event.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\nNote: `UUID` must be unique, and should be prefixed with the plugin's UUID.\n\n\n**Examples:**\n- com.elgato.wavelink.toggle-mute\n- com.elgato.discord.join-voice\n- tv.twitch.go-live"
									},
									UserTitleEnabled: {
										type: "boolean",
										description: "Determines whether the title field is available to the user when viewing the action's property inspector. Setting this to `false` will disable the user from specifying a title, thus allowing the plugin to have exclusive access to the title. Default is `true`, i.e. the title field is enabled.",
										markdownDescription: "Determines whether the title field is available to the user when viewing the action's property inspector. Setting this to `false` will disable the user from specifying a title, thus allowing the plugin to have exclusive access to the title. Default is `true`, i.e. the title field is enabled."
									},
									VisibleInActionsList: {
										type: "boolean",
										description: "Determines whether the action is available to users via the actions list in the Stream Deck application. Setting this to `false` allows for the action to be used as part of pre-defined profiles distributed with the plugins, whilst not being available to users. Default is `true`.",
										markdownDescription: "Determines whether the action is available to users via the actions list in the Stream Deck application. Setting this to `false` allows for the action to be used as part of pre-defined profiles distributed with the plugins, whilst not being available to users. Default is `true`."
									}
								},
								required: [
									"Icon",
									"Name",
									"States",
									"UUID"
								],
								additionalProperties: false
							},
							description: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to user's via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`).",
							markdownDescription: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to user's via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`)."
						},
						Software: {
							type: "object",
							properties: {
								MinimumVersion: {
									type: "string",
									"const": "6.9",
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									markdownDescription: "Minimum version of the Stream Deck application required for this plugin to run."
								}
							},
							required: [
								"MinimumVersion"
							],
							additionalProperties: false,
							description: "Determines the Stream Deck software requirements for this plugin.",
							markdownDescription: "Determines the Stream Deck software requirements for this plugin."
						},
						ApplicationsToMonitor: {
							$ref: "#/definitions/ApplicationMonitoring",
							description: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`",
							markdownDescription: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`"
						},
						Author: {
							type: "string",
							description: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\".",
							markdownDescription: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\"."
						},
						Category: {
							type: "string",
							description: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group.",
							markdownDescription: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group."
						},
						CategoryIcon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							filePath: {
								extensions: [
									".svg",
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								28,
								28
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
						},
						CodePath: {
							type: "string",
							description: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathMac: {
							type: "string",
							description: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathWin: {
							type: "string",
							description: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						DefaultWindowSize: {
							type: "array",
							items: {
								type: "number"
							},
							minItems: 2,
							maxItems: 2,
							description: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`.",
							examples: [
								[
									500,
									650
								]
							],
							markdownDescription: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`."
						},
						Description: {
							type: "string",
							description: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace.",
							markdownDescription: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace."
						},
						Icon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							filePath: {
								extensions: [
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								256,
								256
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .png file in the plugin directory, with the file extension omitted."
						},
						Name: {
							type: "string",
							description: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc.",
							markdownDescription: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc."
						},
						OS: {
							type: "array",
							items: {
								$ref: "#/definitions/OS"
							},
							minItems: 1,
							maxItems: 2,
							description: "Collection of operating systems, and their minimum required versions, that the plugin supports.",
							markdownDescription: "Collection of operating systems, and their minimum required versions, that the plugin supports."
						},
						Profiles: {
							type: "array",
							items: {
								$ref: "#/definitions/Profile"
							},
							description: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`",
							markdownDescription: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`"
						},
						PropertyInspectorPath: {
							type: "string",
							description: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							filePath: {
								extensions: [
									".htm",
									".html"
								],
								includeExtension: true
							},
							markdownDescription: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
							errorMessage: "String must reference .htm, or .html file in the plugin directory."
						},
						SDKVersion: {
							type: "number",
							"enum": [
								2,
								3
							],
							description: "Preferred SDK version (version 3 is recommended).",
							markdownDescription: "Preferred SDK version (version 3 is recommended)."
						},
						SupportURL: {
							type: "string",
							description: "Link to the plugin's support website.\n\n**Examples**:\n- https://help.corsair.com/\n- https://help.elgato.com/\n\nAvailable from Stream Deck 6.9.",
							markdownDescription: "Link to the plugin's support website.\n\n**Examples**:\n- https://help.corsair.com/\n- https://help.elgato.com/\n\nAvailable from Stream Deck 6.9."
						},
						URL: {
							type: "string",
							description: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com",
							markdownDescription: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com"
						},
						UUID: {
							type: "string",
							description: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch",
							pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
							errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
							markdownDescription: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch"
						},
						Version: {
							type: "string",
							description: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`.",
							examples: [
								"1.0.0.0"
							],
							pattern: "^(0|[1-9]\\d*)(\\.(0|[1-9]\\d*)){3}$",
							errorMessage: "String must use format {major}.{minor}.{patch}.{build}",
							markdownDescription: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`."
						},
						Nodejs: {
							type: "object",
							additionalProperties: false,
							properties: {
								Version: {
									type: "string",
									"const": "20",
									description: "Version of Node.js to use.",
									markdownDescription: "Version of Node.js to use."
								},
								Debug: {
									type: "string",
									description: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`.",
									examples: [
										"enabled",
										"break"
									],
									markdownDescription: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`."
								},
								GenerateProfilerOutput: {
									type: "boolean",
									description: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling).",
									markdownDescription: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling)."
								}
							},
							required: [
								"Version"
							],
							description: "Configuration options for Node.js based plugins.",
							markdownDescription: "Configuration options for Node.js based plugins."
						}
					},
					required: [
						"Actions",
						"Author",
						"CodePath",
						"Description",
						"Icon",
						"Name",
						"OS",
						"SDKVersion",
						"Software",
						"UUID",
						"Version"
					]
				}
			},
			{
				"if": {
					type: "object",
					properties: {
						Software: {
							type: "object",
							description: "Determines the Stream Deck software requirements for this plugin.",
							properties: {
								MinimumVersion: {
									type: "string",
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									"const": "7.0"
								}
							},
							required: [
								"MinimumVersion"
							]
						}
					},
					required: [
						"Software"
					]
				},
				then: {
					type: "object",
					additionalProperties: false,
					properties: {
						$schema: {
							type: "string",
							description: "JSON schema responsible for describing the manifest's data format and validation.",
							markdownDescription: "JSON schema responsible for describing the manifest's data format and validation."
						},
						Nodejs: {
							type: "object",
							additionalProperties: false,
							properties: {
								Version: {
									type: "string",
									"const": "20",
									description: "Version of Node.js to use.",
									markdownDescription: "Version of Node.js to use."
								},
								Debug: {
									type: "string",
									description: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`.",
									examples: [
										"enabled",
										"break"
									],
									markdownDescription: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`."
								},
								GenerateProfilerOutput: {
									type: "boolean",
									description: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling).",
									markdownDescription: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling)."
								}
							},
							required: [
								"Version"
							],
							description: "Configuration options for Node.js based plugins.",
							markdownDescription: "Configuration options for Node.js based plugins."
						},
						Software: {
							type: "object",
							properties: {
								MinimumVersion: {
									type: "string",
									"const": "7.0",
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									markdownDescription: "Minimum version of the Stream Deck application required for this plugin to run."
								}
							},
							required: [
								"MinimumVersion"
							],
							additionalProperties: false,
							description: "Determines the Stream Deck software requirements for this plugin.",
							markdownDescription: "Determines the Stream Deck software requirements for this plugin."
						},
						Actions: {
							type: "array",
							items: {
								$ref: "#/definitions/Action"
							},
							description: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to users via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`).",
							markdownDescription: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to users via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`)."
						},
						ApplicationsToMonitor: {
							$ref: "#/definitions/ApplicationMonitoring",
							description: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`",
							markdownDescription: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`"
						},
						Author: {
							type: "string",
							description: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\".",
							markdownDescription: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\"."
						},
						Category: {
							type: "string",
							description: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group.",
							markdownDescription: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group."
						},
						CategoryIcon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							filePath: {
								extensions: [
									".svg",
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								28,
								28
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
						},
						CodePath: {
							type: "string",
							description: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathMac: {
							type: "string",
							description: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathWin: {
							type: "string",
							description: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						DefaultWindowSize: {
							type: "array",
							items: {
								type: "number"
							},
							minItems: 2,
							maxItems: 2,
							description: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`.",
							examples: [
								[
									500,
									650
								]
							],
							markdownDescription: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`."
						},
						Description: {
							type: "string",
							description: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace.",
							markdownDescription: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace."
						},
						Icon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							filePath: {
								extensions: [
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								256,
								256
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .png file in the plugin directory, with the file extension omitted."
						},
						Name: {
							type: "string",
							description: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc.",
							markdownDescription: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc."
						},
						OS: {
							type: "array",
							items: {
								$ref: "#/definitions/OS"
							},
							minItems: 1,
							maxItems: 2,
							description: "Collection of operating systems, and their minimum required versions, that the plugin supports.",
							markdownDescription: "Collection of operating systems, and their minimum required versions, that the plugin supports."
						},
						Profiles: {
							type: "array",
							items: {
								$ref: "#/definitions/Profile"
							},
							description: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`",
							markdownDescription: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`"
						},
						PropertyInspectorPath: {
							type: "string",
							description: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							filePath: {
								extensions: [
									".htm",
									".html"
								],
								includeExtension: true
							},
							markdownDescription: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
							errorMessage: "String must reference .htm, or .html file in the plugin directory."
						},
						SDKVersion: {
							type: "number",
							"enum": [
								2,
								3
							],
							description: "Preferred SDK version (version 3 is recommended).",
							markdownDescription: "Preferred SDK version (version 3 is recommended)."
						},
						SupportURL: {
							type: "string",
							description: "Link to the plugin's support website.\n\n**Examples**:\n- https://help.corsair.com/\n- https://help.elgato.com/\n\nAvailable from Stream Deck 6.9.",
							markdownDescription: "Link to the plugin's support website.\n\n**Examples**:\n- https://help.corsair.com/\n- https://help.elgato.com/\n\nAvailable from Stream Deck 6.9."
						},
						URL: {
							type: "string",
							description: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com",
							markdownDescription: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com"
						},
						UUID: {
							type: "string",
							description: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch",
							pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
							errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
							markdownDescription: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch"
						},
						Version: {
							type: "string",
							description: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`.",
							examples: [
								"1.0.0.0"
							],
							pattern: "^(0|[1-9]\\d*)(\\.(0|[1-9]\\d*)){3}$",
							errorMessage: "String must use format {major}.{minor}.{patch}.{build}",
							markdownDescription: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`."
						}
					},
					required: [
						"Actions",
						"Author",
						"CodePath",
						"Description",
						"Icon",
						"Name",
						"OS",
						"SDKVersion",
						"Software",
						"UUID",
						"Version"
					]
				}
			},
			{
				"if": {
					type: "object",
					properties: {
						Software: {
							type: "object",
							description: "Determines the Stream Deck software requirements for this plugin.",
							properties: {
								MinimumVersion: {
									type: "string",
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									"const": "7.1"
								}
							},
							required: [
								"MinimumVersion"
							]
						}
					},
					required: [
						"Software"
					]
				},
				then: {
					type: "object",
					additionalProperties: false,
					properties: {
						$schema: {
							type: "string",
							description: "JSON schema responsible for describing the manifest's data format and validation.",
							markdownDescription: "JSON schema responsible for describing the manifest's data format and validation."
						},
						Software: {
							type: "object",
							properties: {
								MinimumVersion: {
									type: "string",
									"enum": [
										"7.1",
										"7.2"
									],
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									markdownDescription: "Minimum version of the Stream Deck application required for this plugin to run."
								}
							},
							required: [
								"MinimumVersion"
							],
							additionalProperties: false,
							description: "Determines the Stream Deck software requirements for this plugin.",
							markdownDescription: "Determines the Stream Deck software requirements for this plugin."
						},
						Actions: {
							type: "array",
							items: {
								$ref: "#/definitions/Action"
							},
							description: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to users via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`).",
							markdownDescription: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to users via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`)."
						},
						ApplicationsToMonitor: {
							$ref: "#/definitions/ApplicationMonitoring",
							description: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`",
							markdownDescription: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`"
						},
						Author: {
							type: "string",
							description: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\".",
							markdownDescription: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\"."
						},
						Category: {
							type: "string",
							description: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group.",
							markdownDescription: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group."
						},
						CategoryIcon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							filePath: {
								extensions: [
									".svg",
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								28,
								28
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
						},
						CodePath: {
							type: "string",
							description: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathMac: {
							type: "string",
							description: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathWin: {
							type: "string",
							description: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						DefaultWindowSize: {
							type: "array",
							items: {
								type: "number"
							},
							minItems: 2,
							maxItems: 2,
							description: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`.",
							examples: [
								[
									500,
									650
								]
							],
							markdownDescription: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`."
						},
						Description: {
							type: "string",
							description: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace.",
							markdownDescription: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace."
						},
						Icon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							filePath: {
								extensions: [
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								256,
								256
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .png file in the plugin directory, with the file extension omitted."
						},
						Name: {
							type: "string",
							description: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc.",
							markdownDescription: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc."
						},
						Nodejs: {
							$ref: "#/definitions/Nodejs",
							description: "Configuration options for Node.js based plugins.\n\nNote: All Node.js plugins are executed with the following command-line arguments:\n\n- [`--no-addons`](https://nodejs.org/api/cli.html#--no-addons) (Stream Deck 6.4 only)\n- [`--enable-source-maps`](https://nodejs.org/api/cli.html#--enable-source-maps)\n- [`--no-global-search-paths`](https://nodejs.org/api/cli.html#--no-global-search-paths)",
							markdownDescription: "Configuration options for Node.js based plugins.\n\nNote: All Node.js plugins are executed with the following command-line arguments:\n\n- [`--no-addons`](https://nodejs.org/api/cli.html#--no-addons) (Stream Deck 6.4 only)\n- [`--enable-source-maps`](https://nodejs.org/api/cli.html#--enable-source-maps)\n- [`--no-global-search-paths`](https://nodejs.org/api/cli.html#--no-global-search-paths)"
						},
						OS: {
							type: "array",
							items: {
								$ref: "#/definitions/OS"
							},
							minItems: 1,
							maxItems: 2,
							description: "Collection of operating systems, and their minimum required versions, that the plugin supports.",
							markdownDescription: "Collection of operating systems, and their minimum required versions, that the plugin supports."
						},
						Profiles: {
							type: "array",
							items: {
								$ref: "#/definitions/Profile"
							},
							description: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`",
							markdownDescription: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`"
						},
						PropertyInspectorPath: {
							type: "string",
							description: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							filePath: {
								extensions: [
									".htm",
									".html"
								],
								includeExtension: true
							},
							markdownDescription: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
							errorMessage: "String must reference .htm, or .html file in the plugin directory."
						},
						SDKVersion: {
							type: "number",
							"enum": [
								2,
								3
							],
							description: "Preferred SDK version (version 3 is recommended).",
							markdownDescription: "Preferred SDK version (version 3 is recommended)."
						},
						SupportURL: {
							type: "string",
							description: "Link to the plugin's support website.\n\n**Examples**:\n- https://help.corsair.com/\n- https://help.elgato.com/\n\nAvailable from Stream Deck 6.9.",
							markdownDescription: "Link to the plugin's support website.\n\n**Examples**:\n- https://help.corsair.com/\n- https://help.elgato.com/\n\nAvailable from Stream Deck 6.9."
						},
						URL: {
							type: "string",
							description: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com",
							markdownDescription: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com"
						},
						UUID: {
							type: "string",
							description: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch",
							pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
							errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
							markdownDescription: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch"
						},
						Version: {
							type: "string",
							description: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`.",
							examples: [
								"1.0.0.0"
							],
							pattern: "^(0|[1-9]\\d*)(\\.(0|[1-9]\\d*)){3}$",
							errorMessage: "String must use format {major}.{minor}.{patch}.{build}",
							markdownDescription: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`."
						}
					},
					required: [
						"Actions",
						"Author",
						"CodePath",
						"Description",
						"Icon",
						"Name",
						"OS",
						"SDKVersion",
						"Software",
						"UUID",
						"Version"
					]
				}
			},
			{
				"if": {
					type: "object",
					properties: {
						Software: {
							type: "object",
							description: "Determines the Stream Deck software requirements for this plugin.",
							properties: {
								MinimumVersion: {
									type: "string",
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									"const": "7.2"
								}
							},
							required: [
								"MinimumVersion"
							]
						}
					},
					required: [
						"Software"
					]
				},
				then: {
					type: "object",
					additionalProperties: false,
					properties: {
						$schema: {
							type: "string",
							description: "JSON schema responsible for describing the manifest's data format and validation.",
							markdownDescription: "JSON schema responsible for describing the manifest's data format and validation."
						},
						Software: {
							type: "object",
							properties: {
								MinimumVersion: {
									type: "string",
									"enum": [
										"7.1",
										"7.2"
									],
									description: "Minimum version of the Stream Deck application required for this plugin to run.",
									markdownDescription: "Minimum version of the Stream Deck application required for this plugin to run."
								}
							},
							required: [
								"MinimumVersion"
							],
							additionalProperties: false,
							description: "Determines the Stream Deck software requirements for this plugin.",
							markdownDescription: "Determines the Stream Deck software requirements for this plugin."
						},
						Actions: {
							type: "array",
							items: {
								$ref: "#/definitions/Action"
							},
							description: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to users via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`).",
							markdownDescription: "Collection of actions provided by the plugin, and all of their information; this can include actions that are available to users via the actions list, and actions that are hidden to the user but available to pre-defined profiles distributed with the plugin (`Manifest.Actions.VisibleInActionsList`)."
						},
						ApplicationsToMonitor: {
							$ref: "#/definitions/ApplicationMonitoring",
							description: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`",
							markdownDescription: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.\n\n**Also see:**\n- `streamDeck.system.onApplicationDidLaunch(...)`\n- `streamDeck.system.onApplicationDidTerminate(...)`"
						},
						Author: {
							type: "string",
							description: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\".",
							markdownDescription: "Author's name that will be displayed on the plugin's product page on the Marketplace, e.g. \"Elgato\"."
						},
						Category: {
							type: "string",
							description: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group.",
							markdownDescription: "Defines the actions list group, providing a natural grouping of the plugin's actions with the Stream Deck application's action list.\n\nNote: `Category` should be distinctive and synonymous with your plugin, and it is therefore recommended that this be the same value as the plugin's `Name` field. When `undefined`, the actions will be available under the \"Custom\" group."
						},
						CategoryIcon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							filePath: {
								extensions: [
									".svg",
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								28,
								28
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action list group within the Stream Deck application. The icon should accurately represent the plugin, and enable users to quickly identify the plugin.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 28 × 28 px and 56 × 56 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples**:\n- assets/category-icon\n- imgs/category",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
						},
						CodePath: {
							type: "string",
							description: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's main entry point; this is executed when the Stream Deck application starts the plugin.\n\n**Examples**:\n- index.js\n- Counter\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathMac: {
							type: "string",
							description: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to macOS; this is executed when the Stream Deck application starts the plugin on macOS.\n\n**Examples:**\n- index.js\n- Counter",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						CodePathWin: {
							type: "string",
							description: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							filePath: true,
							markdownDescription: "Path to the plugin's entry point specific to Windows; this is executed when the Stream Deck application starts the plugin on Windows.\n\n**Examples:**\n- index.js\n- Counter.exe",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*$",
							errorMessage: "String must reference file in the plugin directory."
						},
						DefaultWindowSize: {
							type: "array",
							items: {
								type: "number"
							},
							minItems: 2,
							maxItems: 2,
							description: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`.",
							examples: [
								[
									500,
									650
								]
							],
							markdownDescription: "Size of a window (`[width, height]`) opened when calling `window.open()` from the property inspector. Default value is `[500, 650]`."
						},
						Description: {
							type: "string",
							description: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace.",
							markdownDescription: "Description of the plugin, and the functionality it provides, that will be displayed on the plugin's product page on the Marketplace."
						},
						Icon: {
							type: "string",
							description: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							filePath: {
								extensions: [
									".png"
								],
								includeExtension: false
							},
							imageDimensions: [
								256,
								256
							],
							markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed within Stream Deck's preferences.\n\nImage must be:\n- PNG format.\n- Provided in two sizes, 256 × 256 px and 512 × 512 px (@2x).\n\n**Examples:**\n- assets/plugin-icon\n- imgs/plugin",
							pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Pp][Nn][Gg]))$).*$",
							errorMessage: "String must reference .png file in the plugin directory, with the file extension omitted."
						},
						Name: {
							type: "string",
							description: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc.",
							markdownDescription: "Name of the plugin, e.g. \"Wave Link\", \"Camera Hub\", \"Control Center\", etc."
						},
						Nodejs: {
							$ref: "#/definitions/Nodejs",
							description: "Configuration options for Node.js based plugins.\n\nNote: All Node.js plugins are executed with the following command-line arguments:\n\n- [`--no-addons`](https://nodejs.org/api/cli.html#--no-addons) (Stream Deck 6.4 only)\n- [`--enable-source-maps`](https://nodejs.org/api/cli.html#--enable-source-maps)\n- [`--no-global-search-paths`](https://nodejs.org/api/cli.html#--no-global-search-paths)",
							markdownDescription: "Configuration options for Node.js based plugins.\n\nNote: All Node.js plugins are executed with the following command-line arguments:\n\n- [`--no-addons`](https://nodejs.org/api/cli.html#--no-addons) (Stream Deck 6.4 only)\n- [`--enable-source-maps`](https://nodejs.org/api/cli.html#--enable-source-maps)\n- [`--no-global-search-paths`](https://nodejs.org/api/cli.html#--no-global-search-paths)"
						},
						OS: {
							type: "array",
							items: {
								$ref: "#/definitions/OS"
							},
							minItems: 1,
							maxItems: 2,
							description: "Collection of operating systems, and their minimum required versions, that the plugin supports.",
							markdownDescription: "Collection of operating systems, and their minimum required versions, that the plugin supports."
						},
						Profiles: {
							type: "array",
							items: {
								$ref: "#/definitions/Profile"
							},
							description: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`",
							markdownDescription: "Collection of pre-defined profiles that are distributed with this plugin. Upon the plugin switching to the profile, the user will be prompted to install the profiles.\n\nNote: Plugins may only switch to profiles distributed with the plugin, as defined within the manifest, and cannot access user-defined profiles.\n\n**Also see:** `streamDeck.profiles.switchToProfile(...)`"
						},
						PropertyInspectorPath: {
							type: "string",
							description: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							filePath: {
								extensions: [
									".htm",
									".html"
								],
								includeExtension: true
							},
							markdownDescription: "Optional path to the HTML file that represents the property inspector for all actions; this is displayed to the user in the Stream Deck application when they add an action, allowing them to configure the action's settings.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n **Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html\n\n**Also see:**\n- `streamDeck.ui.onSendToPlugin(...)`",
							pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
							errorMessage: "String must reference .htm, or .html file in the plugin directory."
						},
						SDKVersion: {
							type: "number",
							"enum": [
								2,
								3
							],
							description: "Preferred SDK version (version 3 is recommended).",
							markdownDescription: "Preferred SDK version (version 3 is recommended)."
						},
						SupportURL: {
							type: "string",
							description: "Link to the plugin's support website.\n\n**Examples**:\n- https://help.corsair.com/\n- https://help.elgato.com/\n\nAvailable from Stream Deck 6.9.",
							markdownDescription: "Link to the plugin's support website.\n\n**Examples**:\n- https://help.corsair.com/\n- https://help.elgato.com/\n\nAvailable from Stream Deck 6.9."
						},
						URL: {
							type: "string",
							description: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com",
							markdownDescription: "Link to the plugin's website.\n\n**Examples**:\n- https://elgato.com\n- https://corsair.com"
						},
						UUID: {
							type: "string",
							description: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch",
							pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
							errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
							markdownDescription: "Unique identifier of the plugin, represented in reverse-DNS format.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\n**Examples:**\n- com.elgato.wavelink\n- com.elgato.discord\n- tv.twitch"
						},
						Version: {
							type: "string",
							description: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`.",
							examples: [
								"1.0.0.0"
							],
							pattern: "^(0|[1-9]\\d*)(\\.(0|[1-9]\\d*)){3}$",
							errorMessage: "String must use format {major}.{minor}.{patch}.{build}",
							markdownDescription: "Version of the plugin, in the format `{major}.{minor}.{patch}.{build}`."
						}
					},
					required: [
						"Actions",
						"Author",
						"CodePath",
						"Description",
						"Icon",
						"Name",
						"OS",
						"SDKVersion",
						"Software",
						"UUID",
						"Version"
					]
				}
			}
		],
		type: "object",
		properties: {
			Software: {
				type: "object",
				description: "Determines the Stream Deck software requirements for this plugin.",
				properties: {
					MinimumVersion: {
						type: "string",
						description: "Minimum version of the Stream Deck application required for this plugin to run.",
						"enum": [
							"6.4",
							"6.5",
							"6.6",
							"6.7",
							"6.8",
							"6.9",
							"7.0",
							"7.1",
							"7.2"
						]
					}
				},
				required: [
					"MinimumVersion"
				]
			}
		},
		required: [
			"Software"
		]
	},
	ApplicationMonitoring: {
		type: "object",
		properties: {
			mac: {
				type: "array",
				items: {
					type: "string"
				},
				description: "Collection of applications to monitor on macOS.\n\n**Examples:**\n- com.apple.mail",
				markdownDescription: "Collection of applications to monitor on macOS.\n\n**Examples:**\n- com.apple.mail"
			},
			windows: {
				type: "array",
				items: {
					type: "string"
				},
				description: "Collection of applications to monitor on Windows.\n\n**Examples:**\n- Notepad.exe",
				markdownDescription: "Collection of applications to monitor on Windows.\n\n**Examples:**\n- Notepad.exe"
			}
		},
		additionalProperties: false,
		description: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin.",
		markdownDescription: "Applications to monitor on Mac and Windows; upon a monitored application being launched or terminated, Stream Deck will notify the plugin."
	},
	OS: {
		type: "object",
		properties: {
			MinimumVersion: {
				type: "string",
				description: "Minimum version required of the operating system to run the plugin.",
				markdownDescription: "Minimum version required of the operating system to run the plugin."
			},
			Platform: {
				type: "string",
				"enum": [
					"mac",
					"windows"
				],
				description: "Operating system supported by the plugin.",
				markdownDescription: "Operating system supported by the plugin."
			}
		},
		required: [
			"MinimumVersion",
			"Platform"
		],
		additionalProperties: false,
		description: "Operating system that the plugin supports, and the minimum required version needed to run the plugin.",
		markdownDescription: "Operating system that the plugin supports, and the minimum required version needed to run the plugin."
	},
	Controller: {
		type: "string",
		"enum": [
			"Encoder",
			"Keypad"
		],
		description: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +.",
		markdownDescription: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +."
	},
	Encoder: {
		type: "object",
		properties: {
			Icon: {
				type: "string",
				description: "Path to the image, with the **file extension omitted**, that will be displayed in the Stream Deck application in the circular canvas that represents the dial of the action.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 72 × 72 px and 144 × 144 px (@2x).\n\nNote: Can be overridden by the user in the Stream Deck application.\n\n**Examples:**\n- assets/actions/mute/encoder-icon\n- imgs/join-voice-chat-encoder",
				filePath: {
					extensions: [
						".svg",
						".png"
					],
					includeExtension: false
				},
				imageDimensions: [
					72,
					72
				],
				markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed in the Stream Deck application in the circular canvas that represents the dial of the action.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 72 × 72 px and 144 × 144 px (@2x).\n\nNote: Can be overridden by the user in the Stream Deck application.\n\n**Examples:**\n- assets/actions/mute/encoder-icon\n- imgs/join-voice-chat-encoder",
				pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
				errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
			},
			StackColor: {
				type: "string",
				description: "Background color to display in the Stream Deck application when the action is part of a dial stack, and is the current action. Represented as a hexadecimal value.\n\n**Examples:**\n- #D60270\n- #F1F1F1\n- #0038A8",
				markdownDescription: "Background color to display in the Stream Deck application when the action is part of a dial stack, and is the current action. Represented as a hexadecimal value.\n\n**Examples:**\n- #D60270\n- #F1F1F1\n- #0038A8"
			},
			TriggerDescription: {
				$ref: "#/definitions/TriggerDescriptions",
				description: "Descriptions that define the interaction of the action when it is associated with a dial / touchscreen on the Stream Deck +. This information is shown to the user.\n\n**Examples:**\n- \"Adjust volume\"\n- \"Play / Pause\"",
				markdownDescription: "Descriptions that define the interaction of the action when it is associated with a dial / touchscreen on the Stream Deck +. This information is shown to the user.\n\n**Examples:**\n- \"Adjust volume\"\n- \"Play / Pause\""
			},
			background: {
				type: "string",
				description: "Path to the image, with the **file extension omitted**, that will be displayed on the touchscreen behind the action's layout.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 200 × 100 px and 400 × 200 px (@2x).\n\nNote: Can be overridden by the user in the Stream Deck application.\n\n**Examples:**\n- assets/backgrounds/main\n- imgs/bright-blue-bg",
				imageDimensions: [
					200,
					100
				],
				filePath: {
					extensions: [
						".png",
						".svg"
					],
					includeExtension: false
				},
				markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed on the touchscreen behind the action's layout.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 200 × 100 px and 400 × 200 px (@2x).\n\nNote: Can be overridden by the user in the Stream Deck application.\n\n**Examples:**\n- assets/backgrounds/main\n- imgs/bright-blue-bg",
				pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Pp][Nn][Gg])|([Ss][Vv][Gg]))$).*$",
				errorMessage: "String must reference .png, or .svg file in the plugin directory, with the file extension omitted."
			},
			layout: {
				anyOf: [
					{
						type: "string",
						description: "File path, relative to the manifest's location.",
						markdownDescription: "File path, relative to the manifest's location."
					},
					{
						type: "string",
						"const": "$A0"
					},
					{
						type: "string",
						"const": "$A1"
					},
					{
						type: "string",
						"const": "$B1"
					},
					{
						type: "string",
						"const": "$B2"
					},
					{
						type: "string",
						"const": "$C1"
					},
					{
						type: "string",
						"const": "$X1"
					}
				],
				description: "Name of a pre-defined layout, or the path to a JSON file that details a custom layout and its components, to be rendered on the action's touchscreen canvas.\n\n**Pre-defined Layouts:**\n- `$X1`, layout with the title at the top and the icon beneath it in the center.\n- `$A0`, layout with the title at the top and a full-width image canvas beneath it in the center.\n- `$A1`, layout with the title at the top, the icon on the left, and text value on the right.\n- `$B1`, layout with the title at the top, the icon on the left, and a text value on the right with a progress bar beneath it.\n- `$B2`, layout with the title at the top, the icon on the left, and a text value on the right with a gradient progress bar beneath it.\n- `$C1`, layout with the title at the top, and two rows that display an icon on the left and progress bar on the right (i.e. a double progress bar layout).\n\n**Examples:**\n- $A1\n- layouts/my-custom-layout.json",
				examples: [
					"$X1",
					"$A0",
					"$A1",
					"$B1",
					"$B2",
					"$C1",
					"custom.json"
				],
				pattern: "^(^(?![\\.]*[\\\\\\/]+).+\\.([Jj][Ss][Oo][Nn])$)|(\\$(X1|A0|A1|B1|B2|C1))$",
				errorMessage: "String must reference .json file in the plugin directory, or a pre-defined layout.",
				markdownDescription: "Name of a pre-defined layout, or the path to a JSON file that details a custom layout and its components, to be rendered on the action's touchscreen canvas.\n\n**Pre-defined Layouts:**\n- `$X1`, layout with the title at the top and the icon beneath it in the center.\n- `$A0`, layout with the title at the top and a full-width image canvas beneath it in the center.\n- `$A1`, layout with the title at the top, the icon on the left, and text value on the right.\n- `$B1`, layout with the title at the top, the icon on the left, and a text value on the right with a progress bar beneath it.\n- `$B2`, layout with the title at the top, the icon on the left, and a text value on the right with a gradient progress bar beneath it.\n- `$C1`, layout with the title at the top, and two rows that display an icon on the left and progress bar on the right (i.e. a double progress bar layout).\n\n**Examples:**\n- $A1\n- layouts/my-custom-layout.json"
			}
		},
		additionalProperties: false,
		description: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen).",
		markdownDescription: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen)."
	},
	TriggerDescriptions: {
		type: "object",
		properties: {
			LongTouch: {
				type: "string",
				description: "Touchscreen \"long-touch\" interaction behavior description.",
				markdownDescription: "Touchscreen \"long-touch\" interaction behavior description."
			},
			Push: {
				type: "string",
				description: "Dial \"push\" (press) interaction behavior description.",
				markdownDescription: "Dial \"push\" (press) interaction behavior description."
			},
			Rotate: {
				type: "string",
				description: "Dial rotation interaction behavior description.",
				markdownDescription: "Dial rotation interaction behavior description."
			},
			Touch: {
				type: "string",
				description: "Touchscreen \"touch\" interaction behavior description.",
				markdownDescription: "Touchscreen \"touch\" interaction behavior description."
			}
		},
		additionalProperties: false,
		description: "Descriptions that define the interaction of the action when it is associated with a dial / touchscreen on the Stream Deck +. This information is shown to the user.\n\n**Examples:**\n- \"Adjust volume\"\n- \"Play / Pause\"",
		markdownDescription: "Descriptions that define the interaction of the action when it is associated with a dial / touchscreen on the Stream Deck +. This information is shown to the user.\n\n**Examples:**\n- \"Adjust volume\"\n- \"Play / Pause\""
	},
	State: {
		type: "object",
		properties: {
			FontFamily: {
				type: "string",
				description: "Default font-family to be used when rendering the title of this state.\n\nNote: Can be overridden by the user in the Stream Deck application.",
				markdownDescription: "Default font-family to be used when rendering the title of this state.\n\nNote: Can be overridden by the user in the Stream Deck application."
			},
			FontSize: {
				type: "number",
				description: "Default font-size to be used when rendering the title of this state.\n\nNote: Can be overridden by the user in the Stream Deck application.",
				markdownDescription: "Default font-size to be used when rendering the title of this state.\n\nNote: Can be overridden by the user in the Stream Deck application."
			},
			FontStyle: {
				type: "string",
				"enum": [
					"",
					"Bold Italic",
					"Bold",
					"Italic",
					"Regular"
				],
				description: "Default font-style to be used when rendering the title of this state.\n\nNote: Can be overridden by the user in the Stream Deck application.",
				markdownDescription: "Default font-style to be used when rendering the title of this state.\n\nNote: Can be overridden by the user in the Stream Deck application."
			},
			FontUnderline: {
				type: "boolean",
				description: "Determines whether the title associated with this state is underlined by default.\n\nNote: Can be overridden by the user in the Stream Deck application.",
				markdownDescription: "Determines whether the title associated with this state is underlined by default.\n\nNote: Can be overridden by the user in the Stream Deck application."
			},
			Image: {
				type: "string",
				description: "Path to the image, with the **file extension omitted**, that will be displayed on the Stream Deck when this action's state is active.\n\nImage must be:\n- GIF, PNG or SVG format.\n- Provided in two sizes, 72 × 72 px and 144 × 144 px (@2x).\n\nNote: Can be overridden by the user in the Stream Deck application.\n\n**Examples:**\n- assets/counter-key\n- assets/icons/mute",
				filePath: {
					extensions: [
						".gif",
						".svg",
						".png"
					],
					includeExtension: false
				},
				imageDimensions: [
					72,
					72
				],
				markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed on the Stream Deck when this action's state is active.\n\nImage must be:\n- GIF, PNG or SVG format.\n- Provided in two sizes, 72 × 72 px and 144 × 144 px (@2x).\n\nNote: Can be overridden by the user in the Stream Deck application.\n\n**Examples:**\n- assets/counter-key\n- assets/icons/mute",
				pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Gg][Ii][Ff])|([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
				errorMessage: "String must reference .gif, .svg, or .png file in the plugin directory, with the file extension omitted."
			},
			MultiActionImage: {
				type: "string",
				description: "Path to the image, with the **file extension omitted**, that will be displayed when the action is being viewed as part of a multi-action.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 72 × 72 px and 144 × 144 px (@2x).\n\nNote: Can be overridden by the user in the Stream Deck application.\n\n**Examples:**\n- assets/counter-key\n- assets/icons/mute",
				filePath: {
					extensions: [
						".svg",
						".png"
					],
					includeExtension: false
				},
				imageDimensions: [
					72,
					72
				],
				markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed when the action is being viewed as part of a multi-action.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 72 × 72 px and 144 × 144 px (@2x).\n\nNote: Can be overridden by the user in the Stream Deck application.\n\n**Examples:**\n- assets/counter-key\n- assets/icons/mute",
				pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
				errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
			},
			Name: {
				type: "string",
				description: "Name of the state; when multiple states are defined this value is shown to the user when the action is being added to a multi-action. The user is then able to specify which state they would like to activate as part of the multi-action.",
				markdownDescription: "Name of the state; when multiple states are defined this value is shown to the user when the action is being added to a multi-action. The user is then able to specify which state they would like to activate as part of the multi-action."
			},
			ShowTitle: {
				type: "boolean",
				description: "Determines whether the title should be shown.\n\nNote: Can be overridden by the user in the Stream Deck application.",
				markdownDescription: "Determines whether the title should be shown.\n\nNote: Can be overridden by the user in the Stream Deck application."
			},
			Title: {
				type: "string",
				description: "Default title to be shown when the action is added to the Stream Deck.",
				markdownDescription: "Default title to be shown when the action is added to the Stream Deck."
			},
			TitleAlignment: {
				type: "string",
				"enum": [
					"bottom",
					"middle",
					"top"
				],
				description: "Default title alignment to be used when rendering the title of this state.\n\nNote: Can be overridden by the user in the Stream Deck application.",
				markdownDescription: "Default title alignment to be used when rendering the title of this state.\n\nNote: Can be overridden by the user in the Stream Deck application."
			},
			TitleColor: {
				type: "string",
				description: "Default title color to be used when rendering the title of this state, represented a hexadecimal value.\n\nNote: Can be overridden by the user in the Stream Deck application.\n\n**Examples:**\n- #5BCEFA\n- #F5A9B8\n- #FFFFFF",
				markdownDescription: "Default title color to be used when rendering the title of this state, represented a hexadecimal value.\n\nNote: Can be overridden by the user in the Stream Deck application.\n\n**Examples:**\n- #5BCEFA\n- #F5A9B8\n- #FFFFFF"
			}
		},
		required: [
			"Image"
		],
		additionalProperties: false,
		description: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`.",
		markdownDescription: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`."
	},
	Profile: {
		type: "object",
		properties: {
			AutoInstall: {
				type: "boolean",
				description: "Determines whether the profile should be automatically installed when the plugin is installed. When `false`, the profile will be installed the first time the plugin attempts to switch to it. Default is `true`.\n\nAvailable from Stream Deck 6.6.",
				markdownDescription: "Determines whether the profile should be automatically installed when the plugin is installed. When `false`, the profile will be installed the first time the plugin attempts to switch to it. Default is `true`.\n\nAvailable from Stream Deck 6.6."
			},
			DeviceType: {
				type: "number",
				"enum": [
					0,
					1,
					2,
					3,
					4,
					5,
					6,
					7,
					8,
					9,
					10,
					11
				],
				description: "Type of device the profile is intended for, for example Stream Deck +, Stream Deck Pedal, etc.\n\n**Devices**\n- Stream Deck (0)\n- Stream Deck Mini (1)\n- Stream Deck XL (2)\n- Stream Deck Mobile (3)\n- Corsair GKeys (4)\n- Stream Deck Pedal (5)\n- Corsair Voyager (6)\n- Stream Deck + (7)\n- SCUF Controller (8)\n- Stream Deck Neo (9)\n- Stream Deck Studio (10)\n- Virtual Stream Deck (11)",
				markdownDescription: "Type of device the profile is intended for, for example Stream Deck +, Stream Deck Pedal, etc.\n\n**Devices**\n- Stream Deck (0)\n- Stream Deck Mini (1)\n- Stream Deck XL (2)\n- Stream Deck Mobile (3)\n- Corsair GKeys (4)\n- Stream Deck Pedal (5)\n- Corsair Voyager (6)\n- Stream Deck + (7)\n- SCUF Controller (8)\n- Stream Deck Neo (9)\n- Stream Deck Studio (10)\n- Virtual Stream Deck (11)"
			},
			DontAutoSwitchWhenInstalled: {
				type: "boolean",
				description: "Determines whether the Stream Deck application should automatically switch to the profile when it is first installed. Default value is `false`.",
				markdownDescription: "Determines whether the Stream Deck application should automatically switch to the profile when it is first installed. Default value is `false`."
			},
			Name: {
				type: "string",
				description: "Path to the `.streamDeckProfile`, with the **file extension omitted**, that contains the profiles layout and action settings.\n\n**Examples:**\n- assets/main-profile\n- profiles/super-cool-profile",
				filePath: {
					extensions: [
						".streamDeckProfile"
					],
					includeExtension: false
				},
				markdownDescription: "Path to the `.streamDeckProfile`, with the **file extension omitted**, that contains the profiles layout and action settings.\n\n**Examples:**\n- assets/main-profile\n- profiles/super-cool-profile",
				pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Tt][Rr][Ee][Aa][Mm][Dd][Ee][Cc][Kk][Pp][Rr][Oo][Ff][Ii][Ll][Ee]))$).*$",
				errorMessage: "String must reference .streamDeckProfile file in the plugin directory, with the file extension omitted."
			},
			Readonly: {
				type: "boolean",
				description: "Determines whether the profile is read-only, or if the user is able to customize it within the Stream Deck application. Default value is `false`.",
				markdownDescription: "Determines whether the profile is read-only, or if the user is able to customize it within the Stream Deck application. Default value is `false`."
			}
		},
		required: [
			"DeviceType",
			"Name"
		],
		additionalProperties: false,
		description: "Provides information for pre-defined profile distributed with this plugin.",
		markdownDescription: "Provides information for pre-defined profile distributed with this plugin."
	},
	Action: {
		type: "object",
		properties: {
			Controllers: {
				type: "array",
				items: {
					$ref: "#/definitions/Controller"
				},
				minItems: 1,
				maxItems: 2,
				description: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +.",
				uniqueItems: true,
				markdownDescription: "Defines the controller type the action is applicable to. **Keypad** refers to a standard action on a Stream Deck device, e.g. 1 of the 15 buttons on the Stream Deck MK.2, or a pedal on the Stream Deck Pedal, etc., whereas an **Encoder** refers to a dial / touchscreen on the Stream Deck +."
			},
			DisableAutomaticStates: {
				type: "boolean",
				description: "Determines whether the state of the action should automatically toggle when the user presses the action; only applies to actions that have more than one state defined. Default is `false`.",
				examples: [
					false
				],
				markdownDescription: "Determines whether the state of the action should automatically toggle when the user presses the action; only applies to actions that have more than one state defined. Default is `false`."
			},
			DisableCaching: {
				type: "boolean",
				description: "Determines whether Stream Deck should cache images associated with the plugin, and its actions. Default is `false`.",
				examples: [
					false
				],
				markdownDescription: "Determines whether Stream Deck should cache images associated with the plugin, and its actions. Default is `false`."
			},
			Encoder: {
				$ref: "#/definitions/Encoder",
				description: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen).",
				markdownDescription: "Provides information about how the action functions as part of an `Encoder` (dial / touchscreen)."
			},
			Icon: {
				type: "string",
				description: "Path to the image, with the **file extension omitted**, that will be displayed next to the action in the Stream Deck application's action list.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 20 × 20 px and 40 × 40 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples:**\n- assets/counter\n- imgs/actions/mute",
				filePath: {
					extensions: [
						".svg",
						".png"
					],
					includeExtension: false
				},
				imageDimensions: [
					20,
					20
				],
				markdownDescription: "Path to the image, with the **file extension omitted**, that will be displayed next to the action in the Stream Deck application's action list.\n\nImage must be:\n- PNG or SVG format.\n- Provided in two sizes, 20 × 20 px and 40 × 40 px (@2x).\n- Monochromatic, with foreground color of #FFFFFF and a transparent background.\n\n**Examples:**\n- assets/counter\n- imgs/actions/mute",
				pattern: "^(?![~\\.]*[\\\\\\/]+)(?!.*\\.(([Ss][Vv][Gg])|([Pp][Nn][Gg]))$).*$",
				errorMessage: "String must reference .svg, or .png file in the plugin directory, with the file extension omitted."
			},
			Name: {
				type: "string",
				description: "Name of the action; this is displayed to the user in the actions list, and is used throughout the Stream Deck application to visually identify the action.",
				markdownDescription: "Name of the action; this is displayed to the user in the actions list, and is used throughout the Stream Deck application to visually identify the action."
			},
			OS: {
				type: "array",
				items: {
					type: "string",
					"enum": [
						"mac",
						"windows"
					]
				},
				description: "Operating system that the action supports.",
				minItems: 1,
				maxItems: 2,
				uniqueItems: true,
				markdownDescription: "Operating system that the action supports."
			},
			PropertyInspectorPath: {
				type: "string",
				description: "Optional path to the HTML file that represents the property inspector for this action; this is displayed to the user in the Stream Deck application when they add the action, allowing them to configure the action's settings. When `undefined`, the manifest's top-level `PropertyInspectorPath` is used, otherwise none.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n**Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html",
				filePath: {
					extensions: [
						".htm",
						".html"
					],
					includeExtension: true
				},
				markdownDescription: "Optional path to the HTML file that represents the property inspector for this action; this is displayed to the user in the Stream Deck application when they add the action, allowing them to configure the action's settings. When `undefined`, the manifest's top-level `PropertyInspectorPath` is used, otherwise none.\n\nNote: Path should be relative to the root of the plugin's folder, with no leading slash.\n\n**Examples:**\n- mute.html\n- actions/join-voice-chat/settings.html",
				pattern: "^(?![~\\.]*[\\\\\\/]+).*\\.(([Hh][Tt][Mm])|([Hh][Tt][Mm][Ll]))$",
				errorMessage: "String must reference .htm, or .html file in the plugin directory."
			},
			States: {
				type: "array",
				items: {
					$ref: "#/definitions/State"
				},
				description: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`.",
				minItems: 1,
				markdownDescription: "States the action can be in. When two states are defined the action will act as a toggle, with users being able to select their preferred iconography for each state.\n\nNote: Automatic toggling of the state on action activation can be disabled by setting `DisableAutomaticStates` to `true`."
			},
			SupportedInKeyLogicActions: {
				type: "boolean",
				description: "Determines whether the action is available to users when they are creating key logic actions. Default is `true`.\n\nAvailable from Stream Deck 7.0.",
				markdownDescription: "Determines whether the action is available to users when they are creating key logic actions. Default is `true`.\n\nAvailable from Stream Deck 7.0."
			},
			SupportedInMultiActions: {
				type: "boolean",
				description: "Determines whether the action is available to users when they are creating multi-actions. Default is `true`.",
				markdownDescription: "Determines whether the action is available to users when they are creating multi-actions. Default is `true`."
			},
			SupportURL: {
				type: "string",
				description: "Link to the actions's support website.\n\n**Examples**:\n- https://help.corsair.com/\n- https://help.elgato.com/\n\nAvailable from Stream Deck 6.9.",
				markdownDescription: "Link to the actions's support website.\n\n**Examples**:\n- https://help.corsair.com/\n- https://help.elgato.com/\n\nAvailable from Stream Deck 6.9."
			},
			Tooltip: {
				type: "string",
				description: "Tooltip shown to the user when they hover over the action within the actions list in the Stream Deck application.",
				markdownDescription: "Tooltip shown to the user when they hover over the action within the actions list in the Stream Deck application."
			},
			UUID: {
				type: "string",
				description: "Unique identifier of the action, represented in reverse-DNS format. This value is supplied by Stream Deck when events are emitted that relate to the action enabling you to identify the source of the event.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\nNote: `UUID` must be unique, and should be prefixed with the plugin's UUID.\n\n\n**Examples:**\n- com.elgato.wavelink.toggle-mute\n- com.elgato.discord.join-voice\n- tv.twitch.go-live",
				pattern: "^([a-z0-9-]+)(\\.[a-z0-9-]+)+$",
				errorMessage: "String must be in reverse DNS format, and must only contain lowercase alphanumeric characters (a-z, 0-9), hyphens (-), and periods (.)",
				markdownDescription: "Unique identifier of the action, represented in reverse-DNS format. This value is supplied by Stream Deck when events are emitted that relate to the action enabling you to identify the source of the event.\n\n**Allowed characters:**\n- Lowercase alphanumeric characters (a-z, 0-9)\n- Hyphens (-)\n- Periods (.)\n\nNote: `UUID` must be unique, and should be prefixed with the plugin's UUID.\n\n\n**Examples:**\n- com.elgato.wavelink.toggle-mute\n- com.elgato.discord.join-voice\n- tv.twitch.go-live"
			},
			UserTitleEnabled: {
				type: "boolean",
				description: "Determines whether the title field is available to the user when viewing the action's property inspector. Setting this to `false` will disable the user from specifying a title, thus allowing the plugin to have exclusive access to the title. Default is `true`, i.e. the title field is enabled.",
				markdownDescription: "Determines whether the title field is available to the user when viewing the action's property inspector. Setting this to `false` will disable the user from specifying a title, thus allowing the plugin to have exclusive access to the title. Default is `true`, i.e. the title field is enabled."
			},
			VisibleInActionsList: {
				type: "boolean",
				description: "Determines whether the action is available to users via the actions list in the Stream Deck application. Setting this to `false` allows for the action to be used as part of pre-defined profiles distributed with the plugins, whilst not being available to users. Default is `true`.",
				markdownDescription: "Determines whether the action is available to users via the actions list in the Stream Deck application. Setting this to `false` allows for the action to be used as part of pre-defined profiles distributed with the plugins, whilst not being available to users. Default is `true`."
			}
		},
		required: [
			"Icon",
			"Name",
			"States",
			"UUID"
		],
		additionalProperties: false,
		description: "Provides information about an action provided by the plugin.",
		markdownDescription: "Provides information about an action provided by the plugin."
	},
	Nodejs: {
		type: "object",
		properties: {
			Debug: {
				type: "string",
				description: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`.",
				examples: [
					"enabled",
					"break"
				],
				markdownDescription: "Command-line arguments supplied to the plugin when run in debug mode. Optionally, the pre-defined values `\"enabled\"` and `\"break\"` run the plugin with a debugger enabled with [`--inspect`](https://nodejs.org/api/cli.html#--inspecthostport) and [`--inspect-brk`](https://nodejs.org/api/cli.html#--inspect-brkhostport) respectively.\n\nNote: `\"enabled\"` and `\"break\"` will automatically be assigned an available `PORT` by Stream Deck.  Alternatively, if you wish to debug on a pre-defined port, this value can be a set of [command-line arguments](https://nodejs.org/api/cli.html).\n\n**Examples:**\n- `\"enabled\"` results in `--inspect=127.0.0.1:{PORT}`\n- `\"break\"` results in `--inspect-brk=127.0.0.1:{PORT}`\n- `\"--inspect=127.0.0.1:12345\"` runs a local debugger on port `12345`."
			},
			GenerateProfilerOutput: {
				type: "boolean",
				description: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling).",
				markdownDescription: "Determines whether to generate a profiler output for the plugin; [read more](https://nodejs.org/en/docs/guides/simple-profiling)."
			},
			Version: {
				type: "string",
				"enum": [
					"20",
					"24"
				],
				description: "Version of Node.js to use.",
				markdownDescription: "Version of Node.js to use."
			}
		},
		required: [
			"Version"
		],
		additionalProperties: false,
		description: "Configuration options for Node.js based plugins.",
		markdownDescription: "Configuration options for Node.js based plugins."
	}
};
var manifest = {
	$id: $id,
	$schema: $schema,
	$ref: $ref,
	definitions: definitions
};

export { layout, manifest };
