import type { PluginEvent, UIEvent } from "../../api";
/**
 * Provides information for events received from Stream Deck.
 */
export declare class Event<T extends PluginEvent | UIEvent> {
    /**
     * Event that occurred.
     */
    readonly type: T["event"];
    /**
     * Initializes a new instance of the {@link Event} class.
     * @param source Source of the event, i.e. the original message from Stream Deck.
     */
    constructor(source: T);
}
