import { type MessageGateway } from "../messaging";
import type { Logger } from "./logger";
import type { LogEntry, LogTarget } from "./target";
/**
 * Creates a log target that that sends the log entry to the router.
 * @param router Router to which log entries should be sent to.
 * @returns The log target, attached to the router.
 */
export declare function createRoutedLogTarget(router: MessageGateway<unknown>): LogTarget;
/**
 * Registers a route handler on the router, propagating any log entries to the specified logger for writing.
 * @param router Router to receive inbound log entries on.
 * @param logger Logger responsible for logging log entries.
 */
export declare function registerCreateLogEntryRoute(router: MessageGateway<unknown>, logger: Logger): void;
/**
 * Defines a JSON safe {@link LogEntry}.
 */
export type JsonSafeLogEntry = Omit<LogEntry, "data"> & {
    /**
     * The log message.
     */
    message: string;
};
