import type { JsonValue } from "../json";
/**
 * Determines whether the specified {@link value} is a {@link RawMessageResponse}.
 * @param value Value.
 * @returns `true` when the value of a {@link RawMessageResponse}; otherwise `false`.
 */
export declare function isRequest(value: unknown): value is RawMessageRequest;
/**
 * Determines whether the specified {@link value} is a {@link RawMessageResponse}.
 * @param value Value.
 * @returns `true` when the value of a {@link RawMessageResponse; otherwise `false`.
 */
export declare function isResponse(value: unknown): value is RawMessageResponse;
/**
 * A message sent between the plugin and the property inspector.
 */
type Message<T extends MessageType> = {
    /**
     * Identifies the object as a request or a response.
     */
    readonly __type: T;
    /**
     * Contents of the message.
     */
    readonly body?: JsonValue;
    /**
     * Unique identifier associated with message.
     */
    readonly id: string;
    /**
     * Path of the request.
     */
    readonly path: string;
};
/**
 * Identifies the message type.
 */
type MessageType = "request" | "response";
/**
 * A message request sent from the client.
 */
export type RawMessageRequest = Message<"request"> & {
    /**
     * Indicates whether the request is unidirectional; when `true`, a response will not be awaited.
     */
    readonly unidirectional: boolean;
};
/**
 * A message response sent from the server.
 */
export type RawMessageResponse = Message<"response"> & {
    /**
     * Code that indicates the response status.
     * - `200` the request was successful.
     * - `202` the request was unidirectional, and does not have a response.
     * - `406` the request could not be accepted by the server.
     * - `408` the request timed-out.
     * - `500` the request failed.
     * - `501` the request is not implemented by the server, and could not be fulfilled.
     */
    readonly status: StatusCode;
};
/**
 * Status code of a response.
 * - `200` the request was successful.
 * - `202` the request was unidirectional, and does not have a response.
 * - `406` the request could not be accepted by the server.
 * - `408` the request timed-out.
 * - `500` the request failed.
 * - `501` the request is not implemented by the server, and could not be fulfilled.
 */
export type StatusCode = 
/**
 * The request was successful.
 */
200
/**
 * The request was unidirectional, and does not have a response
 */
 | 202
/**
 * The request could not be accepted by the server.
 */
 | 406
/**
 * The request timed-out.
 */
 | 408
/**
 * The request failed with an error.
 */
 | 500
/**
 * The request is not implemented by the server, and could not be fulfilled.
 */
 | 501;
export {};
