import type { JsonValue } from "../json";
import type { OutboundMessageProxy } from "./gateway";
import type { RawMessageRequest, StatusCode } from "./message";
/**
 * Message responder responsible for responding to a request.
 */
export declare class MessageResponder {
    private readonly request;
    private readonly proxy;
    /**
     * Indicates whether a response has already been sent in relation to the response.
     */
    private _responded;
    /**
     * Initializes a new instance of the {@link MessageResponder} class.
     * @param request The request the response is associated with.
     * @param proxy Proxy responsible for forwarding the response to the client.
     */
    constructor(request: RawMessageRequest, proxy: OutboundMessageProxy);
    /**
     * Indicates whether a response can be sent.
     * @returns `true` when a response has not yet been set.
     */
    get canRespond(): boolean;
    /**
     * Sends a failure response with a status code of `500`.
     * @param body Optional response body.
     * @returns Promise fulfilled once the response has been sent.
     */
    fail(body?: JsonValue): Promise<void>;
    /**
     * Sends the {@link body} as a response with the {@link status}
     * @param status Response status.
     * @param body Optional response body.
     * @returns Promise fulfilled once the response has been sent.
     */
    send(status: StatusCode, body?: JsonValue): Promise<void>;
    /**
     * Sends a success response with a status code of `200`.
     * @param body Optional response body.
     * @returns Promise fulfilled once the response has been sent.
     */
    success(body?: JsonValue): Promise<void>;
}
