/**
 * Wraps an underlying Promise{T}, exposing the resolve and reject delegates as methods, allowing for it to be awaited, resolved, or rejected externally.
 */
export declare class PromiseCompletionSource<T> {
    /**
     * The underlying promise that this instance is managing.
     */
    private readonly _promise;
    /**
     * Delegate used to reject the promise.
     */
    private _reject?;
    /**
     * Delegate used to resolve the promise.
     */
    private _resolve?;
    /**
     * Wraps an underlying Promise{T}, exposing the resolve and reject delegates as methods, allowing for it to be awaited, resolved, or rejected externally.
     */
    constructor();
    /**
     * Gets the underlying promise being managed by this instance.
     * @returns The promise.
     */
    get promise(): Promise<T>;
    /**
     * Rejects the promise, causing any awaited calls to throw.
     * @param reason The reason for rejecting the promise.
     */
    setException(reason?: unknown): void;
    /**
     * Sets the result of the underlying promise, allowing any awaited calls to continue invocation.
     * @param value The value to resolve the promise with.
     */
    setResult(value: PromiseLike<T> | T): void;
}
