import type { Controller, WillAppear, WillDisappear } from "../../api";
import type { JsonObject } from "../../common/json";
import type { Device } from "../devices";
/**
 * Provides information about an instance of a Stream Deck action.
 */
export declare class ActionContext {
    #private;
    /**
     * Initializes a new instance of the {@link ActionContext} class.
     * @param source Source of the action.
     */
    constructor(source: WillAppear<JsonObject> | WillDisappear<JsonObject>);
    /**
     * Type of the action.
     * - `Keypad` is a key.
     * - `Encoder` is a dial and portion of the touch strip.
     * @returns Controller type.
     */
    get controllerType(): Controller;
    /**
     * Stream Deck device the action is positioned on.
     * @returns Stream Deck device.
     */
    get device(): Device;
    /**
     * Action instance identifier.
     * @returns Identifier.
     */
    get id(): string;
    /**
     * Manifest identifier (UUID) for this action type.
     * @returns Manifest identifier.
     */
    get manifestId(): string;
    /**
     * Converts this instance to a serializable object.
     * @returns The serializable object.
     */
    toJSON(): object;
}
