import type { Manifest } from "../../api";
import type { Constructor, Unpack } from "../common/utils";
import type { SingletonAction } from "./singleton-action";
/**
 * Definition used to define an action.
 */
type ActionDefinition = Pick<Unpack<Manifest["Actions"]>, "UUID">;
/**
 * Defines a Stream Deck action associated with the plugin.
 * @param definition The definition of the action, e.g. it's identifier, name, etc.
 * @returns The definition decorator.
 */
export declare function action(definition: ActionDefinition): <T extends Constructor<SingletonAction>>(target: T, context: ClassDecoratorContext) => {
    new (...args: any[]): {
        /**
         * The universally-unique value that identifies the action within the manifest.
         */
        readonly manifestId: string | undefined;
        readonly actions: import("..").Enumerable<import("./dial").DialAction<import("..").JsonObject> | import("./key").KeyAction<import("..").JsonObject>>;
        onDialDown?(ev: import("..").DialDownEvent<import("..").JsonObject>): Promise<void> | void;
        onDialRotate?(ev: import("..").DialRotateEvent<import("..").JsonObject>): Promise<void> | void;
        onDialUp?(ev: import("..").DialUpEvent<import("..").JsonObject>): Promise<void> | void;
        onDidReceiveSettings?(ev: import("..").DidReceiveSettingsEvent<import("..").JsonObject>): Promise<void> | void;
        onKeyDown?(ev: import("..").KeyDownEvent<import("..").JsonObject>): Promise<void> | void;
        onKeyUp?(ev: import("..").KeyUpEvent<import("..").JsonObject>): Promise<void> | void;
        onPropertyInspectorDidAppear?(ev: import("..").PropertyInspectorDidAppearEvent<import("..").JsonObject>): Promise<void> | void;
        onPropertyInspectorDidDisappear?(ev: import("..").PropertyInspectorDidDisappearEvent<import("..").JsonObject>): Promise<void> | void;
        onSendToPlugin?(ev: import("..").SendToPluginEvent<import("..").JsonValue, import("..").JsonObject>): Promise<void> | void;
        onTitleParametersDidChange?(ev: import("..").TitleParametersDidChangeEvent<import("..").JsonObject>): Promise<void> | void;
        onTouchTap?(ev: import("..").TouchTapEvent<import("..").JsonObject>): Promise<void> | void;
        onWillAppear?(ev: import("..").WillAppearEvent<import("..").JsonObject>): Promise<void> | void;
        onWillDisappear?(ev: import("..").WillDisappearEvent<import("..").JsonObject>): Promise<void> | void;
    };
} & T;
export {};
