import { Enumerable } from "../../common/enumerable";
import type { DialAction } from "./dial";
import type { KeyAction } from "./key";
/**
 * Provides a read-only store of Stream Deck devices.
 */
export declare class ReadOnlyActionStore extends Enumerable<DialAction | KeyAction> {
    /**
     * Initializes a new instance of the {@link ReadOnlyActionStore}.
     */
    constructor();
    /**
     * Gets the action with the specified identifier.
     * @param id Identifier of action to search for.
     * @returns The action, when present; otherwise `undefined`.
     */
    getActionById(id: string): DialAction | KeyAction | undefined;
}
/**
 * Provides a store of Stream Deck actions.
 */
declare class ActionStore extends ReadOnlyActionStore {
    /**
     * Deletes the action from the store.
     * @param id The action's identifier.
     */
    delete(id: string): void;
    /**
     * Adds the action to the store.
     * @param action The action.
     */
    set(action: DialAction | KeyAction): void;
}
/**
 * Singleton instance of the action store.
 */
export declare const actionStore: ActionStore;
export {};
