/**
 * Provides information for a version, as parsed from a string denoted as a collection of numbers separated by a period, for example `1.45.2`, `4.0.2.13098`. Parsing is opinionated
 * and strings should strictly conform to the format `{major}[.{minor}[.{patch}[.{build}]]]`; version numbers that form the version are optional, and when `undefined` will default to
 * 0, for example the `minor`, `patch`, or `build` number may be omitted.
 *
 * NB: This implementation should be considered fit-for-purpose, and should be used sparing.
 */
export declare class Version {
    /**
     * Build version number.
     */
    readonly build: number;
    /**
     * Major version number.
     */
    readonly major: number;
    /**
     * Minor version number.
     */
    readonly minor: number;
    /**
     * Patch version number.
     */
    readonly patch: number;
    /**
     * Initializes a new instance of the {@link Version} class.
     * @param value Value to parse the version from.
     */
    constructor(value: string);
    /**
     * Compares this instance to the {@link other} {@link Version}.
     * @param other The {@link Version} to compare to.
     * @returns `-1` when this instance is less than the {@link other}, `1` when this instance is greater than {@link other}, otherwise `0`.
     */
    compareTo(other: VersionInfo): number;
    /** @inheritdoc */
    toString(): string;
}
/**
 * Numerical version values associated with a {@link Version}.
 */
type VersionInfo = Pick<Version, "build" | "major" | "minor" | "patch">;
export {};
