import type { DeviceInfo, DeviceType, Size } from "../../api";
import type { DialAction } from "../actions/dial";
import type { KeyAction } from "../actions/key";
/**
 * Provides information about a device.
 */
export declare class Device {
    #private;
    /**
     * Unique identifier of the device.
     */
    readonly id: string;
    /**
     * Initializes a new instance of the {@link Device} class.
     * @param id Device identifier.
     * @param info Information about the device.
     * @param isConnected Determines whether the device is connected.
     */
    constructor(id: string, info: DeviceInfo, isConnected: boolean);
    /**
     * Actions currently visible on the device.
     * @returns Collection of visible actions.
     */
    get actions(): IterableIterator<DialAction | KeyAction>;
    /**
     * Determines whether the device is currently connected.
     * @returns `true` when the device is connected; otherwise `false`.
     */
    get isConnected(): boolean;
    /**
     * Name of the device, as specified by the user in the Stream Deck application.
     * @returns Name of the device.
     */
    get name(): string;
    /**
     * Number of action slots, excluding dials / touchscreens, available to the device.
     * @returns Size of the device.
     */
    get size(): Size;
    /**
     * Type of the device that was connected, e.g. Stream Deck +, Stream Deck Pedal, etc. See {@link DeviceType}.
     * @returns Type of the device.
     */
    get type(): DeviceType;
}
