import type { IDisposable } from "../../common/disposable";
import { type DeviceDidChangeEvent, type DeviceDidConnectEvent, type DeviceDidDisconnectEvent } from "../events";
import { ReadOnlyDeviceStore } from "./store";
/**
 * Provides functions, and information, for interacting with Stream Deck actions.
 */
declare class DeviceService extends ReadOnlyDeviceStore {
    /**
     * Initializes a new instance of the {@link DeviceService}.
     */
    constructor();
    /**
     * Occurs when a Stream Deck device changed, for example its name or size.
     *
     * Available from Stream Deck 7.0.
     * @param listener Function to be invoked when the event occurs.
     * @returns A disposable that, when disposed, removes the listener.
     */
    onDeviceDidChange(listener: (ev: DeviceDidChangeEvent) => void): IDisposable;
    /**
     * Occurs when a Stream Deck device is connected. See also {@link DeviceService.onDeviceDidConnect}.
     * @param listener Function to be invoked when the event occurs.
     * @returns A disposable that, when disposed, removes the listener.
     */
    onDeviceDidConnect(listener: (ev: DeviceDidConnectEvent) => void): IDisposable;
    /**
     * Occurs when a Stream Deck device is disconnected. See also {@link DeviceService.onDeviceDidDisconnect}.
     * @param listener Function to be invoked when the event occurs.
     * @returns A disposable that, when disposed, removes the listener.
     */
    onDeviceDidDisconnect(listener: (ev: DeviceDidDisconnectEvent) => void): IDisposable;
}
/**
 * Provides functions, and information, for interacting with Stream Deck actions.
 */
export declare const deviceService: DeviceService;
export { type DeviceService };
