import { Enumerable } from "../../common/enumerable";
import type { Device } from "./device";
/**
 * Provides a read-only store of Stream Deck devices.
 */
export declare class ReadOnlyDeviceStore extends Enumerable<Device> {
    /**
     * Initializes a new instance of the {@link ReadOnlyDeviceStore}.
     */
    constructor();
    /**
     * Gets the Stream Deck {@link Device} associated with the specified {@link deviceId}.
     * @param deviceId Identifier of the Stream Deck device.
     * @returns The Stream Deck device information; otherwise `undefined` if a device with the {@link deviceId} does not exist.
     */
    getDeviceById(deviceId: string): Device | undefined;
}
/**
 * Provides a store of Stream Deck devices.
 */
declare class DeviceStore extends ReadOnlyDeviceStore {
    /**
     * Adds the device to the store.
     * @param device The device.
     */
    set(device: Device): void;
}
/**
 * Singleton instance of the device store.
 */
export declare const deviceStore: DeviceStore;
export {};
