import type { DidReceiveDeepLink } from "../../api";
import { Event } from "../../common/events";
/**
 * Event information received from Stream Deck as part of a deep-link message being routed to the plugin.
 */
export declare class DidReceiveDeepLinkEvent extends Event<DidReceiveDeepLink> {
    /**
     * Deep-link URL routed from Stream Deck.
     */
    readonly url: DeepLinkURL;
    /**
     * Initializes a new instance of the {@link DidReceiveDeepLinkEvent} class.
     * @param source Source of the event, i.e. the original message from Stream Deck.
     */
    constructor(source: DidReceiveDeepLink);
}
/**
 * Provides information associated with a URL received as part of a deep-link message, conforming to the URI syntax defined within RFC-3986 (https://datatracker.ietf.org/doc/html/rfc3986#section-3).
 */
export declare class DeepLinkURL {
    /**
     * Fragment of the URL, with the number sign (#) omitted. For example, a URL of "/test#heading" would result in a {@link DeepLinkURL.fragment} of "heading".
     */
    readonly fragment: string;
    /**
     * Original URL. For example, a URL of "/test?one=two#heading" would result in a {@link DeepLinkURL.href} of "/test?one=two#heading".
     */
    readonly href: string;
    /**
     * Path of the URL; the full URL with the query and fragment omitted. For example, a URL of "/test?one=two#heading" would result in a {@link DeepLinkURL.path} of "/test".
     */
    readonly path: string;
    /**
     * Query of the URL, with the question mark (?) omitted. For example, a URL of "/test?name=elgato&key=123" would result in a {@link DeepLinkURL.query} of "name=elgato&key=123".
     * See also {@link DeepLinkURL.queryParameters}.
     */
    readonly query: string;
    /**
     * Query string parameters parsed from the URL. See also {@link DeepLinkURL.query}.
     */
    readonly queryParameters: URLSearchParams;
    /**
     * Initializes a new instance of the {@link DeepLinkURL} class.
     * @param url URL of the deep-link, with the schema and authority omitted.
     */
    constructor(url: string);
    /**
     * Parses the {@link DeepLinkURL.path} from the specified {@link href}.
     * @param href Partial URL that contains the path to parse.
     * @returns The path of the URL.
     */
    private static parsePath;
}
