import type { DeviceDidChange, DeviceDidConnect, DeviceDidDisconnect } from "../../api";
import { Event } from "../../common/events";
/**
 * Provides information for events relating to a device.
 */
export declare class DeviceEvent<T extends DeviceDidChange | DeviceDidConnect | DeviceDidDisconnect, TDevice> extends Event<T> {
    readonly device: TDevice;
    /**
     * Initializes a new instance of the {@link DeviceEvent} class.
     * @param source Source of the event, i.e. the original message from Stream Deck.
     * @param device Device that event is associated with.
     */
    constructor(source: T, device: TDevice);
}
