import type { DidReceivePropertyInspectorMessage } from "../../api";
import { Event } from "../../common/events";
import type { JsonObject, JsonValue } from "../../common/json";
import type { Action } from "../actions/action";
/**
 * Provides information for an event triggered by a message being sent to the plugin, from the property inspector.
 */
export declare class SendToPluginEvent<TPayload extends JsonValue, TSettings extends JsonObject> extends Event<DidReceivePropertyInspectorMessage<TPayload>> {
    readonly action: Action<TSettings>;
    /**
     * Payload sent from the property inspector.
     */
    payload: TPayload;
    /**
     * Initializes a new instance of the {@link SendToPluginEvent} class.
     * @param action Action that raised the event.
     * @param source Source of the event, i.e. the original message from Stream Deck.
     */
    constructor(action: Action<TSettings>, source: DidReceivePropertyInspectorMessage<TPayload>);
}
