import type { Manifest, RegistrationInfo } from "../api";
import { I18nProvider } from "../common/i18n";
import { type Logger } from "../common/logging";
import { type ActionService } from "./actions/service";
import { type DeviceService } from "./devices/service";
import * as profiles from "./profiles";
import * as settings from "./settings";
import * as system from "./system";
import { type UIController } from "./ui";
export { BarSubType, DeviceType, Target, type Bar, type Controller, type Coordinates, type DeviceInfo, type FeedbackPayload, type GBar, type Language, type Manifest, type Pixmap, type RegistrationInfo, type Size, type State, type Text, } from "../api";
export { Enumerable } from "../common/enumerable";
export { EventEmitter, EventsOf } from "../common/event-emitter";
export { type JsonObject, type JsonPrimitive, type JsonValue } from "../common/json";
export { LogLevel } from "../common/logging";
export { type MessageRequestOptions, type MessageResponder, type MessageResponse, type RouteConfiguration, type StatusCode, } from "../common/messaging";
export * from "./actions";
export * from "./devices";
export type * from "./events";
export { route, type MessageRequest, type PropertyInspector } from "./ui";
export { type Logger };
export declare const streamDeck: {
    /**
     * Namespace for event listeners and functionality relating to Stream Deck actions.
     * @returns Actions namespace.
     */
    readonly actions: ActionService;
    /**
     * Namespace for interacting with Stream Deck devices.
     * @returns Devices namespace.
     */
    readonly devices: DeviceService;
    /**
     * Internalization provider, responsible for managing localizations and translating resources.
     * @returns Internalization provider.
     */
    readonly i18n: I18nProvider;
    /**
     * Registration and application information provided by Stream Deck during initialization.
     * @returns Registration information.
     */
    readonly info: Omit<RegistrationInfo, "devices">;
    /**
     * Logger responsible for capturing log messages.
     * @returns The logger.
     */
    readonly logger: Logger;
    /**
     * Manifest associated with the plugin, as defined within the `manifest.json` file.
     * @returns The manifest.
     */
    readonly manifest: Manifest;
    /**
     * Namespace for Stream Deck profiles.
     * @returns Profiles namespace.
     */
    readonly profiles: typeof profiles;
    /**
     * Namespace for persisting settings within Stream Deck.
     * @returns Settings namespace.
     */
    readonly settings: typeof settings;
    /**
     * Namespace for interacting with, and receiving events from, the system the plugin is running on.
     * @returns System namespace.
     */
    readonly system: typeof system;
    /**
     * Namespace for interacting with UI (property inspector) associated with the plugin.
     * @returns UI namespace.
     */
    readonly ui: UIController;
    /**
     * Connects the plugin to the Stream Deck.
     * @returns A promise resolved when a connection has been established.
     */
    connect(): Promise<void>;
};
export default streamDeck;
