import type { Language } from "../api";
import { I18nProvider } from "../common/i18n";
import type { JsonObject } from "../common/json";
/**
 * Internalization provider, responsible for managing localizations and translating resources.
 */
export declare const i18n: I18nProvider;
/**
 * Loads a locale from the file system using `fetch`.
 * @param language Language to load.
 * @returns Contents of the locale.
 */
export declare function xmlHttpRequestLocaleProviderSync(language: Language): JsonObject | null;
/**
 * Gets the current working directory.
 * @returns The directory.
 */
export declare function cwd(): string;
