import streamDeck, { LogLevel } from "@elgato/streamdeck";
import { ToggleDeckAction } from "./actions/toggle-deck.js";
import { ResetAction } from "./actions/reset.js";
import { RecordAction } from "./actions/record.js";
import { SaveAction } from "./actions/save.js";

// Set log level
streamDeck.logger.setLevel(LogLevel.DEBUG);

// Register actions
streamDeck.actions.registerAction(new ToggleDeckAction());
streamDeck.actions.registerAction(new ResetAction());
streamDeck.actions.registerAction(new RecordAction());
streamDeck.actions.registerAction(new SaveAction());

// Connect to Stream Deck
streamDeck.connect();
